"""
Copyright (C) 2008-2009  Miguel Angel Tinte
email: matinte@libresoft.es

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.
"""

import sys
import MySQLdb

import queriesQualOSS


def connectDatabase(host, user, passwd, db):
    
	try:
		conn = MySQLdb.connect (host = host,
					user = user,
					passwd = passwd,
					db = db)
		return conn

	except MySQLdb.Error, e:
		print "Error %d: %s" % (e.args[0], e.args[1])
		sys.exit (1) 



def runcvsanalyQueries(db_host, db_user, db_passwd, cvsanaly_db):

                # run queries for cvsanaly
                conn = connectDatabase(db_host, db_user, db_passwd, cvsanaly_db)
                try:
                        cursor = conn.cursor ()
                        cursor.execute (queriesQualOSS.cm_sra2)
			cursor.execute(queriesQualOSS.cm_sra3_scm)
			cursor.execute(queriesQualOSS.delete_tbcore)
			cursor.execute(queriesQualOSS.create_tbcore)
			cursor.execute(queriesQualOSS.cm_sra4)
			cursor.execute(queriesQualOSS.cm_sra5)
			cursor.execute(queriesQualOSS.cm_sra6)
			cursor.execute(queriesQualOSS.cm_sra7)
			cursor.execute(queriesQualOSS.cm_sra9_scm)
			cursor.execute(queriesQualOSS.cm_iwa1_scm)
			cursor.execute(queriesQualOSS.cm_iwa2)
			cursor.execute(queriesQualOSS.cm_iwa4)
			#cursor.execute(queriesQualOSS.cm_iwa5)
			#cursor.execute(queriesQualOSS.cm_iwa6)
			#cursor.execute(queriesQualOSS.cm_iwa7)
			
                except MySQLdb.Error, e:
                        print "Error %d: %s" % (e.args[0], e.args[1])
                        sys.exit (1)

                conn.commit ()
                conn.close ()


def runmlstatsQueries(db_host, db_user, db_passwd, mlstats_db):

                # run queries for mlstats
                conn = connectDatabase(db_host, db_user, db_passwd, mlstats_db)
                try:
                        cursor = conn.cursor ()
                        cursor.execute (queriesQualOSS.cm_sra3_mls)
                        cursor.execute(queriesQualOSS.cm_iwa1_mls)

                except MySQLdb.Error, e:
                        print "Error %d: %s" % (e.args[0], e.args[1])
                        sys.exit (1)

                conn.commit ()
                conn.close ()


def runbichoQueries(db_host, db_user, db_passwd, bicho_db):

                # run queries for bicho
                conn = connectDatabase(db_host, db_user, db_passwd, bicho_db)
                try:
                        cursor = conn.cursor ()
                        cursor.execute(queriesQualOSS.cm_sra1)
                        cursor.execute(queriesQualOSS.cm_sra3_bts)
                        cursor.execute(queriesQualOSS.cm_sra8)
                        cursor.execute(queriesQualOSS.cm_sra9_bts)
                        cursor.execute(queriesQualOSS.cm_iwa1_bts)
                        cursor.execute(queriesQualOSS.cm_iwa3)

                except MySQLdb.Error, e:
                        print "Error %d: %s" % (e.args[0], e.args[1])
                        sys.exit (1)

                conn.commit ()
                conn.close ()



if __name__ == "__main__":

        if (len(sys.argv) == 7):
		
		db_host = str(sys.argv[1]);
		db_user = str(sys.argv[2]);
		db_password = str(sys.argv[3]);
		cvsanaly_db = str(sys.argv[4]);
		mlstats_db = str(sys.argv[5]);
		bicho_db = str(sys.argv[6]);
		
		# run queries for cvsanaly
		if (cvsanaly_db != "empty"):
			runcvsanalyQueries(db_host, db_user, db_password, cvsanaly_db)    

                # run queries for mlstats
                if (mlstats_db != "empty"):
			runmlstatsQueries(db_host, db_user, db_password, mlstats_db)   

                # run queries for bicho
		if (bicho_db != "empty"):
	                runbichoQueries(db_host, db_user, db_password, bicho_db)   


        else:
                print
                print "Error: bad input arguments number"
                print "Usage: python runQueriesQUalOSS.py db_host db-user db-password cvsanaly-database mlstats-database bicho-database"
		print "For example: python runQueriesQualOSS.py localhost root root [cvsanaly_db|empty] [mlstats_db|empty] [bicho_db|empty]"
                print

