"""
Copyright (C) 2008-2009  Miguel Angel Tinte
email: matinte@libresoft.es

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.
"""

# Queries QualOSS

cm_sra1 = """select g.myyear,g.mymonth,count(g.SubmittedBy) from  (select MID(min(b.DateSubmitted),1,4) myyear,MONTH(left(min(b.DateSubmitted),10)) 		     mymonth, b.SubmittedBy from  Bugs b group by  b.SubmittedBy)g group by  g.myyear, g.mymonth order by  g.myyear, g.mymonth into outfile 
	     '/tmp/cm-sra1' fields terminated by ',' lines terminated by '\n';"""

cm_sra2 = """ select  g.myyear, g.mymonth, count(g.committer_id) from  ( select  s.committer_id, date_format(min(s.date), '%Y') myyear, 
	      date_format(min(s.date), '%m') mymonth from  scmlog s, actions a, file_types ft where s.id=a.commit_id  and a.file_id=ft.file_id and 	
	      ft.type='code' group by  s.committer_id )g group by  g.myyear, g.mymonth order by  g.myyear, g.mymonth into outfile '/tmp/cm-sra2' 
	      fields terminated by ',' lines terminated by '\n';"""


# SCM type
cm_sra3_scm = """select  g.myyear, g.mymonth, count(g.committer_id) Value from
  		( select  s.committer_id, date_format(min(s.date), '%Y') myyear, date_format(min(s.date), '%m') mymonth from  scmlog s, actions a, 			file_types ft where s.id=a.commit_id and a.file_id=ft.file_id and ft.type<>'code' group by  s.committer_id )g group by  g.myyear, 			g.mymonth order by  g.myyear, g.mymonth into outfile '/tmp/cm-sra3-scm' fields terminated by ',' lines terminated by '\n';"""

#BTS type
cm_sra3_bts = """select  g.myyear,g.mymonth, count(g.SubmittedBy) from  (select  date_format(min(left(b.DateSubmitted,17)), '%Y') myyear, 
		 date_format(min(left(b.DateSubmitted,17)), '%m') mymonth, b.SubmittedBy from  Bugs b group by  b.SubmittedBy )g group by 
		 g.myyear,g.mymonth order by  g.myyear,g.mymonth into outfile '/tmp/cm-sra3-bts' fields terminated by ',' lines terminated by '\n';"""

#MLS Type
cm_sra3_mls = """select  g.myyear, g.mymonth, count(g.people_ID) from  (select  date_format(min(m.first_date), '%Y') myyear, 
		 date_format(min(m.first_date), '%m') mymonth, mp.people_ID  from  messages m, messages_people mp where  m.message_ID=mp.message_ID and 		 mp.type_of_recipient='From' group by  mp.people_ID )g  group by  g.myyear, g.mymonth order by g.myyear, g.mymonth into outfile 
		 '/tmp/cm-sra3-mls' fields terminated by ',' lines terminated by '\n';"""


#TableCore:

delete_tbcore = """DROP TABLE IF EXISTS tbcore;"""

create_tbcore = """CREATE TABLE tbcore select tbaux.myyear,tbaux.committer,tbaux.acusum,tbaux.mycom commits from
  (select g.myyear,if(g.committer_id is null,'-',g.committer_id) committer, if(g.committer_id is null,@sumacu:=0,@sumacu:=@sumacu+g.mycom) acusum,
  if(g.committer_id is null,0,g.mycom) mycom from  (SELECT @sumacu:=0) r,(select  date_format(s.date, '%Y') myyear, s.committer_id, count(s.id) mycom
  from  scmlog s group by  date_format(s.date, '%Y'), s.committer_id WITH ROLLUP) g  order by   g.myyear, g.mycom) tbaux, (  select  date_format(s.date, '%Y') myyear, count(s.id) , count(s.id)*20/100 nocore  from  scmlog s  group by  date_format(s.date, '%Y') order by  myyear)tbtotal where tbaux.myyear=tbtotal.myyear and tbaux.acusum>tbtotal.nocore ;"""


#CM-SRA4

cm_sra4 = """select  Q4.coreyear, count(Q4.committer) from (select min(tbcore.myyear) coreyear, tbcore.committer from tbcore
  group by  tbcore.committer order by coreyear) Q4 group by Q4.coreyear into outfile '/tmp/cm-sra4' fields terminated by ',' lines terminated by '\n';"""


#CM-SRA5

cm_sra5 = """select Q5.coreyear, count(Q5.committer) from (select 1+y1.myyear coreyear, y1.committer from (select concat(tbcore.committer, tbcore.myyear)key1,tbcore.myyear, tbcore.committer from tbcore) y1 left join (select concat( tbcore.committer,tbcore.myyear) key2,tbcore.myyear, tbcore.committer from tbcore)y2 on y1.key1+1=y2.key2 where key2 is null and y1.myyear not in (select max(myyear) from tbcore))Q5
  group by Q5.coreyear into outfile '/tmp/cm-sra5' fields terminated by ',' lines terminated by '\n';"""


#CM-SRA6

cm_sra6 = """select  g.coreyear, g.diffnewstopped from (
  select tbq4.coreyear, if(tbq5.corevalue is null, tbq4.corevalue, tbq4.corevalue-tbq5.corevalue) diffnewstopped from (select Q4.coreyear, count(Q4.committer) corevalue from (select min(tbcore.myyear) coreyear, tbcore.committer from tbcore group by  tbcore.committer order by  coreyear) Q4 group by Q4.coreyear)tbq4 left join (select Q5.coreyear, count(Q5.committer) corevalue from (select y1.myyear+1 coreyear, y1.committer from (select concat( tbcore.committer,tbcore.myyear) key1,tbcore.myyear, tbcore.committer from tbcore) y1 left join (select concat( tbcore.committer,tbcore.myyear) key2,tbcore.myyear, tbcore.committer from tbcore)y2 on y1.key1+1=y2.key2 where key2 is null and y1.myyear not in (select max(myyear) from tbcore) )Q5
  group by Q5.coreyear) tbq5 on tbq4.coreyear=tbq5.coreyear union select tbq4.coreyear, tbq5.corevalue*-1  diffnewstopped from (select Q4.coreyear, count(Q4.committer) corevalue from   ( select min(tbcore.myyear) coreyear, tbcore.committer from tbcore group by  tbcore.committer order by  coreyear ) Q4 group by Q4.coreyear)tbq4 right join (select Q5.coreyear, count(Q5.committer) corevalue from ( select y1.myyear+1 coreyear, y1.committer from  (select concat(tbcore.committer,tbcore.myyear) key1,tbcore.myyear, tbcore.committer from tbcore) y1 left join (select concat( tbcore.committer,tbcore.myyear) key2,tbcore.myyear, tbcore.committer from tbcore) y2 on y1.key1+1=y2.key2 where key2 is null and y1.myyear not in (select max(myyear) from tbcore) ) Q5 group by Q5.coreyear) tbq5 on tbq4.coreyear=tbq5.coreyear where tbq4.coreyear is null)g into outfile '/tmp/cm-sra6' fields terminated by ',' lines terminated by '\n';"""


#CM-SRA7
cm_sra7 = """select  sum(total.sum_months)/count(total.list_committers) from(select new.committer_id
  list_committers, count(new.committer_id) sum_months from (select committer_id, date from scmlog
  group by committer_id, year(date), month(date))new group by new.committer_id) total into outfile '/tmp/cm-sra7' fields terminated by ',' lines   	 terminated by '\n';"""


#CM-SRA8
cm_sra8 = """select  date_format(left(b.DateSubmitted,17), '%Y') myyear, count(b.SubmittedBy)
    	     from Bugs b, GeneralInfo g where g.Tracker like '%Patches%' group by myyear into outfile '/tmp/cm-sra8' fields terminated by ',' lines 	
	     terminated by '\n';"""

#CM-SRA9

#SCM type
cm_sra9_scm = """select  date_format(s.date, '%Y') myyear, date_format(s.date, '%m') mymonth, count(distinct s.committer_id) from  scmlog s, actions a, 		 file_types ft where s.id=a.commit_id and a.file_id=ft.file_id and ft.type='code' group by date_format(s.date, '%Y'), 
	     	 date_format(s.date, '%m') order by date_format(s.date, '%Y'), date_format(s.date, '%m') into outfile '/tmp/cm-sra9-scm' fields 		 terminated by ',' lines terminated by '\n';"""

#BTS type
cm_sra9_bts = """select  date_format(left(b.DateSubmitted,17), '%Y') myyear, count(distinct b.SubmittedBy)
    		 from Bugs b, GeneralInfo g where g.Tracker='Patches' group by myyear into outfile '/tmp/cm-sra9-bts' fields terminated by ',' 
		 lines terminated by '\n';"""

#SCM type
cm_iwa1_scm = """select date_format(s.date, '%Y') myyear, date_format(s.date, '%m') mymonth, count(s.id)/count(distinct s.committer_id) 		 
		 avg_commitxcommitter from  scmlog s group by  date_format(s.date, '%Y'), date_format(s.date, '%m') into outfile '/tmp/cm-iwa1-scm' 			 fields terminated by ',' lines terminated by '\n';"""

#BTS type
cm_iwa1_bts = """select date_format(left(b.DateSubmitted,17), '%Y') myyear, date_format(left(b.DateSubmitted,17), '%m') mymonth, 			 		count(b.idBug)/count(distinct b.SubmittedBy) from  Bugs b group by  myyear into outfile '/tmp/cm-iwa1-bts' fields terminated by 
		 ',' lines terminated by '\n';"""


#MLS type
cm_iwa1_mls = """select  date_format(m.first_date, '%Y') year,
    		 count(distinct m.message_ID)/count(distinct mp.people_ID) from  messages m, messages_people mp
    		 where  m.message_ID=mp.message_ID group by  date_format(m.first_date, '%Y') into outfile '/tmp/cm-iwa1-mls' fields terminated by ',' 			 lines terminated by '\n';"""

#CM-IWA2
cm_iwa2 = """select  date_format(s.date, '%Y') myyear, date_format(s.date, '%m'), count(s.id)/count(distinct s.committer_id) avg_commitxcommitter  from  		scmlog s, actions a, file_types ft where s.id=a.commit_id and  a.file_id=ft.file_id and ft.type='code' group by  date_format(s.date, '%Y'), 		date_format(s.date, '%m') order by date_format(s.date, '%Y'), date_format(s.date, '%m') into outfile '/tmp/cm-iwa2' fields terminated by ',' 		lines terminated by '\n';"""

#CM-IWA3
cm_iwa3 = """select count(distinct c.SubmittedBy) from Bugs b,Changes c where b.Status='CLOSED' and c.OldValue<>'CLOSED' and c.Field='status_id' and 		     b.idBug=c.idBug into outfile '/tmp/cm-iwa3' fields terminated by ',' lines terminated by '\n';"""

#CM-IWA4
cm_iwa4 = """select (count(g.file_id) /(select  count(distinct file_id) from actions))*100  from  (select a.file_id, count(distinct s.committer_id)  		     from  actions a, scmlog s where a.commit_id=s.id group by a.file_id having count(distinct s.committer_id)=1) g into outfile '/tmp/cm-iwa4' 	     fields terminated by ',' lines terminated by '\n';"""

#CM-IWA5
cm_iwa5 = """numcommitter = select count(distinct s.committer_id) numcommitteract from scmlog s
	     where date_format(date,'%Y%m%d')>=(select concat(date_format(max(s.date),'%Y')-1,date_format(max(s.date),'%m'),date_format(max(s.date),
	     '%	d')) from scmlog s);"""


#CM-IWA6
cm_iwa6 = """select sum(m.sloc)/ (select count(distinct s.committer_id) numcommitteract from scmlog s where date_format(date,'%Y%m%d')>= 
		(select concat(date_format(max(s.date),'%Y')-1,date_format(max(s.date),'%m'),date_format(max(s.date),'%d')) from scmlog s)) 			linesxcommitter from metrics m into outfile '/tmp/cm-iwa6' fields terminated by ',' lines terminated by '\n';"""


#CM-IWA7
cm_iwa7 = """select count(distinct a.file_id)/(select  count(distinct file_id) from actions) from actions a,
  		(select s.id, s.committer_id numcommitteract from scmlog s where date_format(date,'%Y%m%d')>= 
		(select concat(date_format(max(s.date),'%	Y')-1,date_format(max(s.date),'%m'),  date_format(max(s.date),'%d')) from 
		scmlog s)) g, file_types ft where a.commit_id=g.id and a.file_id=ft.file_id and ft.type='code' into outfile '/tmp/cm-iwa7' fields 			terminated by ',' lines terminated by '\n';"""









