"""
Copyright (C) 2008-2009  Miguel Angel Tinte
email: matinte@libresoft.es

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.
"""

from rpy import r
import sys

def readFileType1(file):
	l1=[]
	l2=[]
	f = open(file, 'r')
	for line in f.readlines():
        	data = line.split(',')
		date = str(data[0]) + "." + str(data[1].strip())
		value=float(data[2])	
		l1.append(date)
		l2.append(value)

	f.close()
	return l1, l2	


def readFileType2(file):
        l1=[]
        l2=[]
        f = open(file, 'r')
        for line in f.readlines():
                data = line.split(',')
                date = str(data[0]) + "." + str(data[1].strip())
                value=int(data[2])
                l1.append(date)
                l2.append(value)

        f.close()
        return l1, l2


def readFileType3(file):
        l1=[]
        l2=[]
        f = open(file, 'r')
        for line in f.readlines():
                data = line.split(',')
                date = str(data[0]) 
                value=int(data[1])
                l1.append(date)
                l2.append(value)

        f.close()
        return l1, l2


def thresholdIndicator(ind):
	colour = "init"
	if (ind > 0):
		colour="Green"	
	elif (ind == 0):
		colour="Yellow"
	elif (ind < 0):
		colour="Red"
	else:
		colour="Black" 
	return colour


if __name__ == "__main__":

        if (len(sys.argv) == 2):

		FILE_INPUT = str(sys.argv[1])
		listDates = []
		listValues = []

		if (FILE_INPUT == "cm-sra2-normal" or FILE_INPUT=="cm-sra9-scm-normal" or FILE_INPUT=="cm-sra3-scm-normal" or FILE_INPUT=="cm-sra3-bts-normal" or FILE_INPUT=="cm-sra1-normal" or 
		FILE_INPUT=="cm-iwa1-scm-normal"):
			listDates, listValues = readFileType1(FILE_INPUT)
		elif (FILE_INPUT == "cm-sra9-scm" or FILE_INPUT == "cm-sra3-scm"):
			listDates, listValues = readFileType2(FILE_INPUT)
		elif (FILE_INPUT == "cm-sra4" or FILE_INPUT == "cm-sra5" or FILE_INPUT == "cm-sra6"):
                        listDates, listValues = readFileType3(FILE_INPUT)
	
		#print listDates
		#print listValues

		indicator = r.lsfit(listDates,listValues)['coefficients']['X']

		fout = open(FILE_INPUT + "-indicators", 'w')
		fout.write(str(indicator) + ", " + thresholdIndicator(indicator) + '\n');
		fout.close()

        else:
                print
                print "Error: bad input arguments number"
                print "Usage: python calcIndicators.py <file>"
                print



