#!/usr/bin/python

# Copyright 2008-2009 Junior (Frederic) FLEURIAL MONFILS
# 
# This file is part of Qualoss-Tools.
#
# Qualoss-Tools is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.
# or see <http://www.opensource.org/licenses/gpl-3.0.html>
# 
# Contact:
#     Junior FLEURIAL MONFILS <frederic dot fleurialmonfils at cetic dot be>
#     Jean-Christophe DEPREZ <jean-christophe dot deprez at cetic dot be>

"""This module extract xml elements based on the provided XML document and xpath
"""

import sys
import os
from lxml import etree

from os.path import splitext, split, basename, dirname, realpath, sep, commonprefix

def usage(message=""):
    """Print the usage message on screen and stop the program
    """
    print >> sys.stderr, """Usage: %s options
    
    Reports to stdout XML elements matching the provided XPATH
    The XML elements are found in the provided XML document
    
    options:
    -f PATH         XML file
    -n              report elements separated by newlines
    -N LABEL,PATH   set label to namespace (Not yet supported)
    -x XPATH        xpath
    --fast          speed up computation
    -h, --help      print this help%s""" % (
        basename(sys.argv[0]),
        message and ("\n\n%s" % message) or ""
    )
    sys.exit(1)
    
tostring = etree.tostring

def tostr(content):
    if isinstance(content, str):
        return content.strip()
    else:
        return tostring(content).strip()
    
def run(options):
    doc = etree.parse(options.f)
    tostring = etree.tostring
    try:
        elements = doc.xpath(options.x)
    except etree.XPathEvalError, e:
        sys.exit("Error: -x xpath %s" % e)
    if options.n:
        for element in elements:
            print tostr(element).strip()
    else:
        print "".join([tostr(element).strip() for element in elements])
    
if __name__ == "__main__":
    import getopt
    short = "f:x:N:hn"
    try:
        # parse the options provide at command line
        opts, args = getopt.getopt(sys.argv[1:], short, ["help", "fast"])
    except getopt.GetoptError, e:
        # if any error, print usage with error text and exit
        usage("Error: %s" % e)
    class options:
        """Basic options class used to collect options from command line
        """
        f=None
        x=None
        N=None
        n=False
        fast=False      # don't speed up
                
        i=sys.stdin     # input is always standard input
        o=sys.stdout    # output is always standard output
    # insert every arguments from command line to options class
    for (opt, arg) in opts:
        if opt == "-h" or opt == "--help":
            # if help is required, show usage and exit
            usage()
        elif opt == "--fast":
            options.fast = True
        elif opt == "-n":
            options.n = True
        # otherwise, set the arg as value of the options class
        else:
            setattr(options, opt[1:], arg)
    # check that all mandatory options are present
    if not (options.f and options.x):
        usage("Error: Missing mandatory options -f or -x")
    # check that provided path exists
    if options.f:
        if not os.path.exists(options.f):
            usage("Error: Path not found '%s'" % options.f)
        # check that provided path is not a directory
        if os.path.isdir(options.f):
            usage("Error: Path '%s' is a directory" % options.f)
        options.i = open(options.f)
    if options.fast:
        try:
            import psyco
            psyco.full()
        except ImportError:
            print >>sys.stderr, "Warning: Psyco not found, running at normal speed"
    # everything is checked, do the actual job
    run(options)
