#!/bin/sh

# Copyright 2008-2009 Junior (Frederic) FLEURIAL MONFILS
#
# This file is part of Qualoss-Tools
#
# Qualoss-Tools is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.
# or see <http://www.opensource.org/licenses/gpl-3.0.html>
#
# Contact:
#     Junior FLEURIAL MONFILS <frederic dot fleurialmonfils at cetic dot be>
#     Jean-Christophe DEPREZ <jean-christophe dot deprez at cetic dot be>

# Compute the number of lines deleted from v1 and v2
# Usage: 
#  (for Java) ./locdiff.sh ".*\.java$" /path/to/v1 /path/to/v2 
#  (for C++) ./locdiff.sh ".*\.(cpp|cc|c|hpp|h)$" /path/to/v1 /path/to/v2
# Returns:
#   Number of Deleted lines from v1
#   Number of Lines in v1
#   Number of Lines in v2

#
# Get the arguments
#

PATTERN=$1
SOURCE_PATH=$2
TARGET_PATH=$3

#
# Prepare
#

# List the files that should be excluded from v1
#find ${SOURCE_PATH} -regextype posix-extended ! -regex "${PATTERN}" -type f -exec basename {} \; > tmp_excluded_files.txt

# List the files that should be excluded from v2 and append it
#find ${TARGET_PATH} -regextype posix-extended ! -regex "${PATTERN}" -type f -exec basename {} \; >> tmp_excluded_files.txt

# List should be sorted as requested by the 'diff' command
#sort -u tmp_excluded_files.txt | uniq > excluded_files.txt
#rm tmp_excluded_files.txt

#
# Execute
#

# Perform the diff
# (makes it slower) -d: try hard to find the minimal set of changes
# -r: recursively
# -b: don't take into account whitespace differences
# -B: don't take into account blank line differences
# -N: if file is not present report the difference as '<' or '>'
# -X: exclude the provided list of files from the count
#diff -r -b -B -N -X excluded_files.txt ${SOURCE_PATH} ${TARGET_PATH} > diff_result.txt
diff -r -b -B -N ${SOURCE_PATH} ${TARGET_PATH} > diff_result.txt

#
# Report
#

# Number of Deleted Lines from v1 to v2
deleted=`grep -e "^<" diff_result.txt | wc -l`
# Number of Lines of Code in v1
#release1=`find ${SOURCE_PATH} -regextype posix-extended -regex "${PATTERN}" -type f | xargs sed '/^[ \t]*$/d' | wc -l`
release1=`find ${SOURCE_PATH} -regextype posix-extended -regex "${PATTERN}" -type f | xargs cat | wc -l`
# Number of Lines of Code in v2
release2=`find ${TARGET_PATH} -regextype posix-extended -regex "${PATTERN}" -type f | xargs cat | wc -l`

if [ $deleted -gt $release1 ]; then
   deleted=$release1
fi
same=`echo "$release1-$deleted" | bc -l`
inserted=`echo "$release2-$same" | bc -l`

if [ $same -ne 0 ]; then
  percentage_change=`echo "scale=4; (2*$deleted+$release2-$release1)/($release1+$release2)" | bc -l`
else
  percentage_change=1
fi

echo "v1: $SOURCE_PATH"
echo "v2: $TARGET_PATH"
echo "Number_of_lines_in_first_v1: $release1"
echo "Number_of_lines_in_second_v2: $release2"
echo "Number_of_deleted_lines_from_v1_to_v2: $deleted"
echo "Number_of_common_lines_between_v1_and_v2: $same"
echo "Number_of_inserted_lines_in_v2: $inserted"
echo "Percentage_of_changes_between_v1_and_v2: $percentage_change"
