-- Copyright 2008-2009 Junior (Frederic) FLEURIAL MONFILS
--
-- This file is part of Qualoss-Tools
--
-- Qualoss-Tools is free software: you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation, either version 3 of the License, or
-- (at your option) any later version.
--
-- This program is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU General Public License for more details.
--
-- You should have received a copy of the GNU General Public License
-- along with this program.  If not, see <http://www.gnu.org/licenses/>.
-- or see <http://www.opensource.org/licenses/gpl-3.0.html>
--
-- Contact:
--     Junior FLEURIAL MONFILS <frederic dot fleurialmonfils at cetic dot be>
--     Jean-Christophe DEPREZ <jean-christophe dot deprez at cetic dot be>

--
-- Number_of_enhancement_proposals
--
-- The number of enhancement proposals are the bugs that are:
--   1) reported as 'enhancement'
--   2) valid enhancements (not labelled as 
--          'duplicate': this enhancement has already been reported
--          'invalid': this enhancement is not an enhancement
--          'moved': this enhancement is placed in the wrong place)
--
SELECT count(1) as Number_of_enhancement_proposals FROM bugs WHERE bug_severity = 'enhancement' and resolution not in ('DUPLICATE', 'INVALID', 'MOVED');


--
-- Number_of_rejected_enhancement_proposals
--
SELECT count(1) as Number_of_rejected_enhancement_proposals FROM bugs WHERE bug_severity = 'enhancement' and resolution in ('WONTFIX', 'WORKSFORME');


--
-- Number_of_accepted_enhancement_proposals
--
SELECT count(1) as Number_of_accepted_enhancement_proposals FROM bugs WHERE bug_severity = 'enhancement' and resolution not in ('WONTFIX', 'DUPLICATE', 'INVALID', 'MOVED', 'WORKSFORME') and bug_status in ('ASSIGNED', 'REOPENED', 'RESOLVED', 'VERIFIED', 'CLOSED');


--
-- Number_of_opened_days_of_accepted_enhancement_proposals_closed
--
SELECT sum((strftime("%s", changeddate) - strftime("%s", opendate))/86400) as Number_of_opened_days_of_accepted_enhancement_proposals_closed FROM bugs WHERE bug_severity = 'enhancement' and resolution not in ('WONTFIX', 'DUPLICATE', 'INVALID', 'MOVED', 'WORKSFORME') and bug_status in ('RESOLVED', 'VERIFIED', 'CLOSED');


--
-- Number_of_opened_days_of_accepted_enhancement_proposals_still_opened
--
SELECT sum((strftime("%s", current_timestamp) - strftime("%s", opendate))/86400) as Number_of_opened_days_of_accepted_enhancement_proposals_still_opened FROM bugs WHERE bug_severity = 'enhancement' and resolution not in ('WONTFIX', 'DUPLICATE', 'INVALID', 'MOVED', 'WORKSFORME') and bug_status in ('ASSIGNED', 'REOPENED');


--
-- Number_of_reported_issues
--
SELECT count(1) as Number_of_reported_issues FROM bugs WHERE bug_severity != 'enhancement' and resolution not in ('DUPLICATE', 'INVALID', 'MOVED');


--
-- Number_of_corrected_issues
--
SELECT count(1) as Number_of_corrected_issues FROM bugs WHERE bug_severity != 'enhancement' and resolution not in ('WONTFIX', 'DUPLICATE', 'INVALID', 'MOVED', 'WORKSFORME') and bug_status in ('CLOSED', 'RESOLVED', 'VERIFIED');


--
-- Number_of_unassigned_issues
--
SELECT count(1) as Number_of_unassigned_issues from bugs where bug_severity != 'enhancement' and bug_status in ('NEW', 'REOPENED', 'UNCONFIRMED');


--
-- Number_of_correction_days
--
SELECT sum((strftime("%s", changeddate) - strftime("%s", opendate))/86400) Number_of_correction_days FROM bugs WHERE bug_severity != 'enhancement' and resolution not in ('WONTFIX', 'DUPLICATE', 'INVALID', 'MOVED', 'WORKSFORME') and bug_status in ('CLOSED', 'RESOLVED', 'VERIFIED');
