#!/bin/sh

# Copyright 2008-2009 Junior (Frederic) FLEURIAL MONFILS
#
# This file is part of Qualoss-Tools
#
# Qualoss-Tools is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.
# or see <http://www.opensource.org/licenses/gpl-3.0.html>
#
# Contact:
#     Junior FLEURIAL MONFILS <frederic dot fleurialmonfils at cetic dot be>
#     Jean-Christophe DEPREZ <jean-christophe dot deprez at cetic dot be>

# Compute the number of api elements deleted from v1 and v2
# Usage: apidiff.sh api_v1.txt api_v2.txt

API_V1=$1
API_V2=$2

#
# Execute
#

# Perform the diff
# -d: try hard to find the minimal set of changes
diff -d ${API_V1} ${API_V2} > diff_result.txt

# Number of Deleted API from v1 to v2
deleted=`grep -e "^<" diff_result.txt | wc -l`
# Number of API elements in v1
release1=`cat ${API_V1} | wc -l`
# Number of Lines of Code in v2
release2=`cat ${API_V2} | wc -l`

same=`echo "$release1-$deleted" | bc -l`
inserted=`echo "$release2-$same" | bc -l`

if [ $same -ne 0 ]; then
  percentage_change=`echo "scale=4; (2*$deleted+$release2-$release1)/($release1+$release2)" | bc -l`
else
  percentage_change=1
fi

echo "v1: $API_V1"
echo "v2: $API_V2"
echo "Number_of_lines_in_first_v1: $release1"
echo "Number_of_lines_in_second_v2: $release2"
echo "Number_of_deleted_lines_from_v1_to_v2: $deleted"
echo "Number_of_common_lines_between_v1_and_v2: $same"
echo "Number_of_inserted_lines_in_v2: $inserted"
echo "Percentage_of_changes_between_v1_and_v2: $percentage_change"
