#!/bin/bash

# Copyright 2008-2009 Junior (Frederic) FLEURIAL MONFILS
#
# This file is part of Qualoss-Tools
#
# Qualoss-Tools is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.
# or see <http://www.opensource.org/licenses/gpl-3.0.html>
#
# Contact:
#     Junior FLEURIAL MONFILS <frederic dot fleurialmonfils at cetic dot be>
#     Jean-Christophe DEPREZ <jean-christophe dot deprez at cetic dot be>

source config.sh

usage() {
  cat <<EOT
Usage::
$0 -t TRACKER -n NAME

Extract Maintainability measures from the downloaded bugtracker CSV files
Pre-requisites:
the bugs and patches has been downloaded to the PROJECT subdirectory
and are named bugs.csv and patches.csv

Example::
$0 -t bugzilla -n httpd13

Options::
    -h
    -t TRACKER   kind of bugtracker (jira, bugzilla)
    -n NAME      template of the name of the downloaded archive
EOT
}

while getopts "t:n:h" flag; do
  case "$flag" in
    t) aTRACKER=$OPTARG;;
    n) aNAME=$OPTARG;;
    h) usage; source clean.sh; exit 2;;
    \?) usage; echo "Error: Invalid option" >&2; source clean.sh; exit 3;; 
  esac
done

vCURDIR=`pwd`
vASSESSMENT_DIR=${gASSESSMENT_DIR}/${aNAME}
cd ${vASSESSMENT_DIR}
vSQLITEFILE=${vASSESSMENT_DIR}/bugs.sqlite

if [ ! -e ${vSQLITEFILE} ]; then
  python ${gSCRIPTS_DIR}/csv2tab.py < bugs.csv > bugs.tab
  cat <<EOS | sqlite3 bugs.sqlite
.read ${gSCRIPTS_DIR}/bugzilla_bug_report_schema.sql
.sep \t
.imp bugs.tab bugs
.exit
EOS
fi
cat <<EOS | sqlite3 bugs.sqlite 
.mode line
.read ${gSCRIPTS_DIR}/bugzilla_bug_queries.sql
.exit
EOS
vNUMPATCHES=`wc -l patches.csv | awk '{print $1}'`
echo "Number_of_submitted_patches = ${vNUMPATCHES}"

cd $vCURDIR

source clean.sh
