package be.cetic.kaos2eventb.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.m2m.atl.core.ATLCoreException;
import org.eclipse.m2m.atl.core.IExtractor;
import org.eclipse.m2m.atl.core.IInjector;
import org.eclipse.m2m.atl.core.IModel;
import org.eclipse.m2m.atl.core.IReferenceModel;
import org.eclipse.m2m.atl.core.ModelFactory;
import org.eclipse.m2m.atl.core.emf.EMFExtractor;
import org.eclipse.m2m.atl.core.emf.EMFInjector;
import org.eclipse.m2m.atl.core.emf.EMFModelFactory;
import org.eclipse.m2m.atl.core.launch.ILauncher;
import org.eclipse.m2m.atl.core.service.CoreService;
import org.eclipse.m2m.atl.engine.emfvm.launch.EMFVMLauncher;

/**
 *
 * @author Xavier Devroey
 */
public class Transformation {

    private static Transformation instance = null;

    private Transformation() {
        CoreService.registerLauncher(new EMFVMLauncher());
        CoreService.registerFactory("EMF", EMFModelFactory.class);
        CoreService.registerExtractor("EMF", new EMFExtractor());
        CoreService.registerInjector("EMF", new EMFInjector());

    }

    public static Transformation getInstance() {
        return instance == null ? instance = new Transformation() : instance;
    }

    public void process(String inputMetamodelURI, String inputModelURI,
            String outputMetamodelURI, String outputModelURI, String asmFilePath)
            throws URISyntaxException, ATLCoreException, MalformedURLException,
            IOException {

        URI inURI = new URI(inputModelURI);
        URI outURI = new URI(outputModelURI);

        ModelFactory factory = CoreService.createModelFactory("EMF");
        IInjector injector = CoreService.getInjector("EMF");
        IExtractor extractor = CoreService.getExtractor("EMF");

        // Metamodels
        IReferenceModel inputMM = factory.newReferenceModel();
        injector.inject(inputMM, inputMetamodelURI);

        IReferenceModel outputMM = factory.newReferenceModel();
        injector.inject(outputMM, outputMetamodelURI);

        // Getting launcher
        ILauncher launcher = null;
        launcher = CoreService.getLauncher("EMF-specific VM"); 
        launcher.initialize(Collections.<String, Object>emptyMap());

        // Creating models
        IModel outputModel = factory.newModel(outputMM);
        IModel inputModel = factory.newModel(inputMM);

        // Loading existing model
        File in = new File(inURI);
        injector.inject(inputModel, in.toURI().toURL().toString());

        File out = new File(outURI);
        if (out.exists()) {
            out.delete();
        }
        out.createNewFile();

        // Launching
        launcher.addInModel(inputModel, "IN", "KAOS");
        launcher.addOutModel(outputModel, "OUT", "SIMPLEEVENTB");

        File asmFile = new File(asmFilePath);

        launcher.launch(ILauncher.RUN_MODE, new NullProgressMonitor(),
                Collections.<String, Object>emptyMap(),
                new FileInputStream(asmFile));

        // Saving model
        extractor.extract(outputModel, out.toURI().toURL().toString());
    }
}
