package be.cetic.kaos2eventb.util;

import be.cetic.kaos2eventb.simpleeventb.Axiom;
import be.cetic.kaos2eventb.simpleeventb.CarrierSet;
import be.cetic.kaos2eventb.simpleeventb.Constant;
import be.cetic.kaos2eventb.simpleeventb.Context;
import be.cetic.kaos2eventb.simpleeventb.ContextExtension;
import be.cetic.kaos2eventb.simpleeventb.ContextView;
import be.cetic.kaos2eventb.simpleeventb.EventBObject;
import be.cetic.kaos2eventb.simpleeventb.Invariant;
import be.cetic.kaos2eventb.simpleeventb.Machine;
import be.cetic.kaos2eventb.simpleeventb.MachineEvent;
import be.cetic.kaos2eventb.simpleeventb.MachineRefinement;
import be.cetic.kaos2eventb.simpleeventb.Project;
import be.cetic.kaos2eventb.simpleeventb.Variable;
import be.cetic.kaos2eventb.simpleeventb.Variant;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.EList;

/**
 *
 * @author Xavier Devroey
 */
public class PrettyPrintProject {

    public static StringBuffer print(Project prj) {
        StringBuffer buff = new StringBuffer("");
        String indent = "   ";
        List<Machine> listeMachines = new ArrayList<Machine>();

        buff.append("PROJECT " + prj.getName() + "\n");
        EList<EventBObject> lst = prj.getElements();

        for (EventBObject concept : lst) {
            if (concept instanceof Machine) {
                listeMachines.add((Machine) concept);
            } else if (concept instanceof Context) {
                printContext((Context) concept, buff, indent);
                buff.append("-----------------------------------------------------\n\n");
            }
        }

        for (Machine m : listeMachines) {
            printMachine(m, buff, indent);
            buff.append("-----------------------------------------------------\n\n");
        }

        return buff;
    }

    private static void printContext(Context context, StringBuffer buff, String indent) {
        buff.append(indent + "CONTEXT " + context.getName() + "\n");

        indent = indent + "   ";

        if (context.getExtends().size() > 0) {
            buff.append(indent + "EXTENDS ");
            for (ContextExtension ext : context.getExtends()) {
                buff.append(ext.getExtendedContext().getName() + " ; ");
            }
            buff.append("\n");
        }

        // Print Sets
        if(context.getSets().size() > 0){
            buff.append(indent+"SETS \n");
            for(CarrierSet set : context.getSets()){
                buff.append(indent+"   "+set.getName()+
                        " \t //"+set.getComment()+" \n");
            }
        }

        // Print Constants
        if(context.getConstants().size() > 0){
            buff.append(indent+"CONSTANTS \n");
            for(Constant constant : context.getConstants()){
                buff.append(indent+"   "+constant.getName()+
                        " \t //"+constant.getComment()+" \n");
            }
        }

        // Print Axioms
        if(context.getAxioms().size() > 0){
            buff.append(indent+"AXIOMS \n");
            for(Axiom axiom : context.getAxioms()){
                buff.append(indent+"   "+axiom.getName()+
                        " : "+axiom.getExpression()+" \t //"+axiom.getComment()+" \n");
            }
        }
    }

    private static void printMachine(Machine machine, StringBuffer buff, String indent) {
        buff.append(indent + "MACHINE " + machine.getName() + "\n");

        indent = indent + "   ";

        if (machine.getRefines().size() > 0) {
            buff.append(indent + "REFINES ");
            for (MachineRefinement ref : machine.getRefines()) {
                buff.append(ref.getRefinedMachine().getName() + " ; ");
            }
            buff.append("\n");
        }
        
        if (machine.getViews().size() > 0) {
            buff.append(indent + "SEES ");
            for (ContextView view : machine.getViews()) {
                buff.append(view.getSeenContext().getName() + " ; ");
            }
            buff.append("\n");
        }

        // Print Variables
        if(machine.getVariables().size() > 0){
            buff.append(indent+"VARIABLES \n");
            for(Variable var : machine.getVariables()){
                buff.append(indent+"   "+var.getName()+
                        " \t //"+var.getComment()+" \n");
            }
        }

        // Print Invariants
        if(machine.getInvariants().size() > 0){
            buff.append(indent+"INVARIANTS \n");
            for(Invariant inv : machine.getInvariants()){
                buff.append(indent+"   "+inv.getName()+
                        " : "+inv.getExpression()+" \t //"+
                        inv.getComment()+" \n");
            }
        }

        // Print Variants
        if(machine.getVariants().size() > 0){
            buff.append(indent+"VARIANTS \n");
            for(Variant var : machine.getVariants()){
                buff.append(indent+"   "+var.getName()+
                        " \t //"+var.getComment()+" \n");
            }
        }

        // Print Events
        if(machine.getEvents().size() > 0){
            buff.append(indent+"EVENTS \n");
            for(MachineEvent evt : machine.getEvents()){
                buff.append(indent+"   Event "+evt.getName()+
                        " \t //"+evt.getComment()+" \n");
            }
        }
    }
}
