package be.cetic.kaos2eventb.util;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.rmi.Naming;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;

import open.kaos.KModel;
import open.kaos.helper.KAOSModel;
import openGrail.tool.emfConnector.ObjectiverModel;

/**
 *
 * @author Xavier Devroey
 */
public class ObjectiverModelToXMI {

    public static final String OBJECTIVER_LOCAL_URL = "rmi://127.0.0.1/ObjectiverModel";
    private ObjectiverModel model;

    public ObjectiverModelToXMI() throws ObjectiverRMIException {
        try {
            this.model = getCurrentModel(OBJECTIVER_LOCAL_URL);
        } catch (MalformedURLException ex) {
            throw new ObjectiverRMIException("Couldn't get ObjectiverModel from Objectiver.", ex);
        } catch (RemoteException ex) {
            throw new ObjectiverRMIException("Couldn't get ObjectiverModel from Objectiver.", ex);
        } catch (NotBoundException ex) {
            throw new ObjectiverRMIException("Couldn't get ObjectiverModel from Objectiver.", ex);
        }
    }

    public ObjectiverModelToXMI(String url) throws ObjectiverRMIException {
        try {
            this.model = getCurrentModel(url);
        } catch (MalformedURLException ex) {
            throw new ObjectiverRMIException("Couldn't get ObjectiverModel from Objectiver.", ex);
        } catch (RemoteException ex) {
            throw new ObjectiverRMIException("Couldn't get ObjectiverModel from Objectiver.", ex);
        } catch (NotBoundException ex) {
            throw new ObjectiverRMIException("Couldn't get ObjectiverModel from Objectiver.", ex);
        }
    }

    private ObjectiverModel getCurrentModel(String objectiverURL) throws MalformedURLException,
            RemoteException, NotBoundException {
        ObjectiverModel m = null;
        m = (ObjectiverModel) Naming.lookup(objectiverURL);
        return m;
    }

    public KModel getKAOSModel() throws ObjectiverRMIException {
        String xmi;
        try {
            xmi = this.model.getXMI();
        } catch (RemoteException ex) {
            throw new ObjectiverRMIException("Couldn't get KModel from Objectiver.", ex);
        }
        KAOSModel kModel = new KAOSModel(xmi);
        return kModel;
    }

    public String ping() throws ObjectiverRMIException{
        try {
            return this.model.ping("Ping from " + Thread.currentThread().toString());
        } catch (RemoteException ex) {
            throw new ObjectiverRMIException("Couldn't ping Objectiver.", ex);
        }
    }

    public String getXMI() throws ObjectiverRMIException {
        String xmi;
        try {
            xmi = model.getXMI();
        } catch (RemoteException ex) {
            throw new ObjectiverRMIException("Couldn't get XMI from Objectiver.", ex);
        }
        return xmi;
    }

    public void toXMIFile(String kaosModelPath, File outputFile) throws ObjectiverRMIException, IOException {
        BufferedWriter writer = null;

        String xmi = this.getXMI();
        if (kaosModelPath != null) {
            xmi = xmi.replace("http://kaos", kaosModelPath);
        }

        // To resolve an error in the XMI comming from Objectiver
        xmi = xmi.replace(" monitorObj=\"/\" ", " ");

        try {
            StringReader reader = new StringReader(xmi);
            char[] buffer = new char[1024];
            int nbrChar;
            if (outputFile.exists()) {
                outputFile.delete();
            }
            outputFile.createNewFile();
            writer = new BufferedWriter(new FileWriter(outputFile));

            while ((nbrChar = reader.read(buffer)) > -1) {
                writer.write(buffer, 0, nbrChar);
            }
            reader.close();
        } finally {
            if (writer != null) {
                try {
                    writer.flush();
                    writer.close();
                } catch (IOException e) {
                    
                }
            }
        }
    }
}
