package be.cetic.kaos2eventb.util;

import be.cetic.kaos2eventb.simpleeventb.Project;
import be.cetic.kaos2eventb.simpleeventb.impl.SimpleeventbPackageImpl;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;

/**
 *
 * @author Xavier Devroey
 */
public class EMFUtilities {

    private String simpleeventbMMURI = "platform:/resource/be.cetic.kaos2eventb/metamodel/eventb/simpleeventb.ecore";
    private String simpleeventbMMEffectiveURI = "file:/./metamodel/simpleeventb.ecore";

    public static final EMFUtilities defaultInstance = new EMFUtilities();

    public EMFUtilities(String effectiveSimpleeventbMetamodelLocation ){
        this.simpleeventbMMEffectiveURI = effectiveSimpleeventbMetamodelLocation;
    }

    private EMFUtilities(){

    }

    public Project getProjectFromXMI(String filePath) {
        Project prj = null;

        ResourceSet resourceSet = new ResourceSetImpl();
        URI fileUri = URI.createFileURI(filePath);

        URI mmURI = URI.createURI(simpleeventbMMURI);
        URI effectiveMMURI = URI.createURI(simpleeventbMMEffectiveURI);
        resourceSet.getURIConverter().getURIMap().put(mmURI, effectiveMMURI);

        Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().put("*",
                new XMIResourceFactoryImpl());

        resourceSet.getPackageRegistry().put(simpleeventbMMEffectiveURI,
                SimpleeventbPackageImpl.eINSTANCE);

        Resource simpleeventbResource = resourceSet.getResource(fileUri, true);
        prj = (Project) simpleeventbResource.getContents().get(0);

        return prj;
    }
}
