/**
 * <copyright>
 * </copyright>
 *
 * $Id: SimpleeventbSwitch.java,v 1.1 2010/01/14 12:55:24 cp Exp $
 */
package be.cetic.kaos2eventb.simpleeventb.util;

import java.util.List;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;

import be.cetic.kaos2eventb.simpleeventb.*;


/**
 * <!-- begin-user-doc -->
 * The <b>Switch</b> for the model's inheritance hierarchy.
 * It supports the call {@link #doSwitch(EObject) doSwitch(object)}
 * to invoke the <code>caseXXX</code> method for each class of the model,
 * starting with the actual class of the object
 * and proceeding up the inheritance hierarchy
 * until a non-null result is returned,
 * which is the result of the switch.
 * <!-- end-user-doc -->
 * @see be.cetic.kaos2eventb.simpleeventb.SimpleeventbPackage
 * @generated
 */
public class SimpleeventbSwitch<T> {
	/**
	 * The cached model package
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected static SimpleeventbPackage modelPackage;

	/**
	 * Creates an instance of the switch.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public SimpleeventbSwitch() {
		if (modelPackage == null) {
			modelPackage = SimpleeventbPackage.eINSTANCE;
		}
	}

	/**
	 * Calls <code>caseXXX</code> for each class of the model until one returns a non null result; it yields that result.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the first non-null result returned by a <code>caseXXX</code> call.
	 * @generated
	 */
	public T doSwitch(EObject theEObject) {
		return doSwitch(theEObject.eClass(), theEObject);
	}

	/**
	 * Calls <code>caseXXX</code> for each class of the model until one returns a non null result; it yields that result.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the first non-null result returned by a <code>caseXXX</code> call.
	 * @generated
	 */
	protected T doSwitch(EClass theEClass, EObject theEObject) {
		if (theEClass.eContainer() == modelPackage) {
			return doSwitch(theEClass.getClassifierID(), theEObject);
		}
		else {
			List<EClass> eSuperTypes = theEClass.getESuperTypes();
			return
				eSuperTypes.isEmpty() ?
					defaultCase(theEObject) :
					doSwitch(eSuperTypes.get(0), theEObject);
		}
	}

	/**
	 * Calls <code>caseXXX</code> for each class of the model until one returns a non null result; it yields that result.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the first non-null result returned by a <code>caseXXX</code> call.
	 * @generated
	 */
	protected T doSwitch(int classifierID, EObject theEObject) {
		switch (classifierID) {
			case SimpleeventbPackage.EVENT_BCONCEPT: {
				EventBConcept eventBConcept = (EventBConcept)theEObject;
				T result = caseEventBConcept(eventBConcept);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case SimpleeventbPackage.EVENT_BOBJECT: {
				EventBObject eventBObject = (EventBObject)theEObject;
				T result = caseEventBObject(eventBObject);
				if (result == null) result = caseEventBConcept(eventBObject);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case SimpleeventbPackage.PROJECT: {
				Project project = (Project)theEObject;
				T result = caseProject(project);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case SimpleeventbPackage.MACHINE: {
				Machine machine = (Machine)theEObject;
				T result = caseMachine(machine);
				if (result == null) result = caseEventBObject(machine);
				if (result == null) result = caseEventBConcept(machine);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case SimpleeventbPackage.CONTEXT: {
				Context context = (Context)theEObject;
				T result = caseContext(context);
				if (result == null) result = caseEventBObject(context);
				if (result == null) result = caseEventBConcept(context);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case SimpleeventbPackage.EVENT_BEXPRESSION: {
				EventBExpression eventBExpression = (EventBExpression)theEObject;
				T result = caseEventBExpression(eventBExpression);
				if (result == null) result = caseEventBConcept(eventBExpression);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case SimpleeventbPackage.EVENT_BMACHINE_EXPRESSION: {
				EventBMachineExpression eventBMachineExpression = (EventBMachineExpression)theEObject;
				T result = caseEventBMachineExpression(eventBMachineExpression);
				if (result == null) result = caseEventBExpression(eventBMachineExpression);
				if (result == null) result = caseEventBConcept(eventBMachineExpression);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case SimpleeventbPackage.EVENT_BCONTEXT_EXPRESSION: {
				EventBContextExpression eventBContextExpression = (EventBContextExpression)theEObject;
				T result = caseEventBContextExpression(eventBContextExpression);
				if (result == null) result = caseEventBExpression(eventBContextExpression);
				if (result == null) result = caseEventBConcept(eventBContextExpression);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case SimpleeventbPackage.VARIABLE: {
				Variable variable = (Variable)theEObject;
				T result = caseVariable(variable);
				if (result == null) result = caseEventBMachineExpression(variable);
				if (result == null) result = caseEventBExpression(variable);
				if (result == null) result = caseEventBConcept(variable);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case SimpleeventbPackage.INVARIANT: {
				Invariant invariant = (Invariant)theEObject;
				T result = caseInvariant(invariant);
				if (result == null) result = caseEventBMachineExpression(invariant);
				if (result == null) result = caseEventBExpression(invariant);
				if (result == null) result = caseEventBConcept(invariant);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case SimpleeventbPackage.VARIANT: {
				Variant variant = (Variant)theEObject;
				T result = caseVariant(variant);
				if (result == null) result = caseEventBMachineExpression(variant);
				if (result == null) result = caseEventBExpression(variant);
				if (result == null) result = caseEventBConcept(variant);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case SimpleeventbPackage.MACHINE_EVENT: {
				MachineEvent machineEvent = (MachineEvent)theEObject;
				T result = caseMachineEvent(machineEvent);
				if (result == null) result = caseEventBMachineExpression(machineEvent);
				if (result == null) result = caseEventBExpression(machineEvent);
				if (result == null) result = caseEventBConcept(machineEvent);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case SimpleeventbPackage.EVENT_BEVENT_EXPRESSION: {
				EventBEventExpression eventBEventExpression = (EventBEventExpression)theEObject;
				T result = caseEventBEventExpression(eventBEventExpression);
				if (result == null) result = caseEventBMachineExpression(eventBEventExpression);
				if (result == null) result = caseEventBExpression(eventBEventExpression);
				if (result == null) result = caseEventBConcept(eventBEventExpression);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case SimpleeventbPackage.PARAMETER: {
				Parameter parameter = (Parameter)theEObject;
				T result = caseParameter(parameter);
				if (result == null) result = caseEventBEventExpression(parameter);
				if (result == null) result = caseEventBMachineExpression(parameter);
				if (result == null) result = caseEventBExpression(parameter);
				if (result == null) result = caseEventBConcept(parameter);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case SimpleeventbPackage.GUARD: {
				Guard guard = (Guard)theEObject;
				T result = caseGuard(guard);
				if (result == null) result = caseEventBEventExpression(guard);
				if (result == null) result = caseEventBMachineExpression(guard);
				if (result == null) result = caseEventBExpression(guard);
				if (result == null) result = caseEventBConcept(guard);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case SimpleeventbPackage.WITNESS: {
				Witness witness = (Witness)theEObject;
				T result = caseWitness(witness);
				if (result == null) result = caseEventBEventExpression(witness);
				if (result == null) result = caseEventBMachineExpression(witness);
				if (result == null) result = caseEventBExpression(witness);
				if (result == null) result = caseEventBConcept(witness);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case SimpleeventbPackage.ACTION: {
				Action action = (Action)theEObject;
				T result = caseAction(action);
				if (result == null) result = caseEventBEventExpression(action);
				if (result == null) result = caseEventBMachineExpression(action);
				if (result == null) result = caseEventBExpression(action);
				if (result == null) result = caseEventBConcept(action);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case SimpleeventbPackage.EVENT_BLINK: {
				EventBLink eventBLink = (EventBLink)theEObject;
				T result = caseEventBLink(eventBLink);
				if (result == null) result = caseEventBObject(eventBLink);
				if (result == null) result = caseEventBConcept(eventBLink);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case SimpleeventbPackage.MACHINE_REFINEMENT: {
				MachineRefinement machineRefinement = (MachineRefinement)theEObject;
				T result = caseMachineRefinement(machineRefinement);
				if (result == null) result = caseEventBLink(machineRefinement);
				if (result == null) result = caseEventBObject(machineRefinement);
				if (result == null) result = caseEventBConcept(machineRefinement);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case SimpleeventbPackage.CONTEXT_EXTENSION: {
				ContextExtension contextExtension = (ContextExtension)theEObject;
				T result = caseContextExtension(contextExtension);
				if (result == null) result = caseEventBLink(contextExtension);
				if (result == null) result = caseEventBObject(contextExtension);
				if (result == null) result = caseEventBConcept(contextExtension);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case SimpleeventbPackage.CONTEXT_VIEW: {
				ContextView contextView = (ContextView)theEObject;
				T result = caseContextView(contextView);
				if (result == null) result = caseEventBLink(contextView);
				if (result == null) result = caseEventBObject(contextView);
				if (result == null) result = caseEventBConcept(contextView);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case SimpleeventbPackage.EVENT_REFINEMENT: {
				EventRefinement eventRefinement = (EventRefinement)theEObject;
				T result = caseEventRefinement(eventRefinement);
				if (result == null) result = caseEventBLink(eventRefinement);
				if (result == null) result = caseEventBObject(eventRefinement);
				if (result == null) result = caseEventBConcept(eventRefinement);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case SimpleeventbPackage.CARRIER_SET: {
				CarrierSet carrierSet = (CarrierSet)theEObject;
				T result = caseCarrierSet(carrierSet);
				if (result == null) result = caseEventBContextExpression(carrierSet);
				if (result == null) result = caseEventBExpression(carrierSet);
				if (result == null) result = caseEventBConcept(carrierSet);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case SimpleeventbPackage.CONSTANT: {
				Constant constant = (Constant)theEObject;
				T result = caseConstant(constant);
				if (result == null) result = caseEventBContextExpression(constant);
				if (result == null) result = caseEventBExpression(constant);
				if (result == null) result = caseEventBConcept(constant);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case SimpleeventbPackage.AXIOM: {
				Axiom axiom = (Axiom)theEObject;
				T result = caseAxiom(axiom);
				if (result == null) result = caseEventBContextExpression(axiom);
				if (result == null) result = caseEventBExpression(axiom);
				if (result == null) result = caseEventBConcept(axiom);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case SimpleeventbPackage.DECOMPOSITION_LINK: {
				DecompositionLink decompositionLink = (DecompositionLink)theEObject;
				T result = caseDecompositionLink(decompositionLink);
				if (result == null) result = caseEventBLink(decompositionLink);
				if (result == null) result = caseEventBObject(decompositionLink);
				if (result == null) result = caseEventBConcept(decompositionLink);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case SimpleeventbPackage.RECOMPOSITION_LINK: {
				RecompositionLink recompositionLink = (RecompositionLink)theEObject;
				T result = caseRecompositionLink(recompositionLink);
				if (result == null) result = caseEventBLink(recompositionLink);
				if (result == null) result = caseEventBObject(recompositionLink);
				if (result == null) result = caseEventBConcept(recompositionLink);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case SimpleeventbPackage.TRACEABILITY_LINK: {
				TraceabilityLink traceabilityLink = (TraceabilityLink)theEObject;
				T result = caseTraceabilityLink(traceabilityLink);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case SimpleeventbPackage.DEPENDENCY: {
				Dependency dependency = (Dependency)theEObject;
				T result = caseDependency(dependency);
				if (result == null) result = caseTraceabilityLink(dependency);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case SimpleeventbPackage.INTRAVERSION: {
				Intraversion intraversion = (Intraversion)theEObject;
				T result = caseIntraversion(intraversion);
				if (result == null) result = caseDependency(intraversion);
				if (result == null) result = caseTraceabilityLink(intraversion);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case SimpleeventbPackage.INTERVERSION: {
				Interversion interversion = (Interversion)theEObject;
				T result = caseInterversion(interversion);
				if (result == null) result = caseDependency(interversion);
				if (result == null) result = caseTraceabilityLink(interversion);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case SimpleeventbPackage.USE_LINK: {
				UseLink useLink = (UseLink)theEObject;
				T result = caseUseLink(useLink);
				if (result == null) result = caseIntraversion(useLink);
				if (result == null) result = caseDependency(useLink);
				if (result == null) result = caseTraceabilityLink(useLink);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case SimpleeventbPackage.DERIVATION: {
				Derivation derivation = (Derivation)theEObject;
				T result = caseDerivation(derivation);
				if (result == null) result = caseIntraversion(derivation);
				if (result == null) result = caseDependency(derivation);
				if (result == null) result = caseTraceabilityLink(derivation);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case SimpleeventbPackage.VARIANT_VERSION: {
				VariantVersion variantVersion = (VariantVersion)theEObject;
				T result = caseVariantVersion(variantVersion);
				if (result == null) result = caseInterversion(variantVersion);
				if (result == null) result = caseDependency(variantVersion);
				if (result == null) result = caseTraceabilityLink(variantVersion);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case SimpleeventbPackage.REVISION: {
				Revision revision = (Revision)theEObject;
				T result = caseRevision(revision);
				if (result == null) result = caseInterversion(revision);
				if (result == null) result = caseDependency(revision);
				if (result == null) result = caseTraceabilityLink(revision);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case SimpleeventbPackage.AGENT_DERIVATION: {
				AgentDerivation agentDerivation = (AgentDerivation)theEObject;
				T result = caseAgentDerivation(agentDerivation);
				if (result == null) result = caseDerivation(agentDerivation);
				if (result == null) result = caseIntraversion(agentDerivation);
				if (result == null) result = caseDependency(agentDerivation);
				if (result == null) result = caseTraceabilityLink(agentDerivation);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case SimpleeventbPackage.ENTITY_OBJECT_DERIVATION: {
				EntityObjectDerivation entityObjectDerivation = (EntityObjectDerivation)theEObject;
				T result = caseEntityObjectDerivation(entityObjectDerivation);
				if (result == null) result = caseDerivation(entityObjectDerivation);
				if (result == null) result = caseIntraversion(entityObjectDerivation);
				if (result == null) result = caseDependency(entityObjectDerivation);
				if (result == null) result = caseTraceabilityLink(entityObjectDerivation);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case SimpleeventbPackage.ATTRIBUTE_DERIVATION: {
				AttributeDerivation attributeDerivation = (AttributeDerivation)theEObject;
				T result = caseAttributeDerivation(attributeDerivation);
				if (result == null) result = caseDerivation(attributeDerivation);
				if (result == null) result = caseIntraversion(attributeDerivation);
				if (result == null) result = caseDependency(attributeDerivation);
				if (result == null) result = caseTraceabilityLink(attributeDerivation);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case SimpleeventbPackage.ATTRIBUTE_DOMAIN_DERIVATION: {
				AttributeDomainDerivation attributeDomainDerivation = (AttributeDomainDerivation)theEObject;
				T result = caseAttributeDomainDerivation(attributeDomainDerivation);
				if (result == null) result = caseDerivation(attributeDomainDerivation);
				if (result == null) result = caseIntraversion(attributeDomainDerivation);
				if (result == null) result = caseDependency(attributeDomainDerivation);
				if (result == null) result = caseTraceabilityLink(attributeDomainDerivation);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case SimpleeventbPackage.DIRECTED_ASSOCIATION_DERIVATION: {
				DirectedAssociationDerivation directedAssociationDerivation = (DirectedAssociationDerivation)theEObject;
				T result = caseDirectedAssociationDerivation(directedAssociationDerivation);
				if (result == null) result = caseDerivation(directedAssociationDerivation);
				if (result == null) result = caseIntraversion(directedAssociationDerivation);
				if (result == null) result = caseDependency(directedAssociationDerivation);
				if (result == null) result = caseTraceabilityLink(directedAssociationDerivation);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case SimpleeventbPackage.UNDIRECTED_ASSOCIATION_DERIVATION: {
				UndirectedAssociationDerivation undirectedAssociationDerivation = (UndirectedAssociationDerivation)theEObject;
				T result = caseUndirectedAssociationDerivation(undirectedAssociationDerivation);
				if (result == null) result = caseDerivation(undirectedAssociationDerivation);
				if (result == null) result = caseIntraversion(undirectedAssociationDerivation);
				if (result == null) result = caseDependency(undirectedAssociationDerivation);
				if (result == null) result = caseTraceabilityLink(undirectedAssociationDerivation);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case SimpleeventbPackage.IS_ADERIVATION: {
				IsADerivation isADerivation = (IsADerivation)theEObject;
				T result = caseIsADerivation(isADerivation);
				if (result == null) result = caseDerivation(isADerivation);
				if (result == null) result = caseIntraversion(isADerivation);
				if (result == null) result = caseDependency(isADerivation);
				if (result == null) result = caseTraceabilityLink(isADerivation);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case SimpleeventbPackage.AGENT_OBJECT_DERIVATION: {
				AgentObjectDerivation agentObjectDerivation = (AgentObjectDerivation)theEObject;
				T result = caseAgentObjectDerivation(agentObjectDerivation);
				if (result == null) result = caseDerivation(agentObjectDerivation);
				if (result == null) result = caseIntraversion(agentObjectDerivation);
				if (result == null) result = caseDependency(agentObjectDerivation);
				if (result == null) result = caseTraceabilityLink(agentObjectDerivation);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case SimpleeventbPackage.EVENT_OBJECT_DERIVATION: {
				EventObjectDerivation eventObjectDerivation = (EventObjectDerivation)theEObject;
				T result = caseEventObjectDerivation(eventObjectDerivation);
				if (result == null) result = caseDerivation(eventObjectDerivation);
				if (result == null) result = caseIntraversion(eventObjectDerivation);
				if (result == null) result = caseDependency(eventObjectDerivation);
				if (result == null) result = caseTraceabilityLink(eventObjectDerivation);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case SimpleeventbPackage.REQUIREMENT_DERIVATION: {
				RequirementDerivation requirementDerivation = (RequirementDerivation)theEObject;
				T result = caseRequirementDerivation(requirementDerivation);
				if (result == null) result = caseDerivation(requirementDerivation);
				if (result == null) result = caseIntraversion(requirementDerivation);
				if (result == null) result = caseDependency(requirementDerivation);
				if (result == null) result = caseTraceabilityLink(requirementDerivation);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case SimpleeventbPackage.EXPECTATION_DERIVATION: {
				ExpectationDerivation expectationDerivation = (ExpectationDerivation)theEObject;
				T result = caseExpectationDerivation(expectationDerivation);
				if (result == null) result = caseDerivation(expectationDerivation);
				if (result == null) result = caseIntraversion(expectationDerivation);
				if (result == null) result = caseDependency(expectationDerivation);
				if (result == null) result = caseTraceabilityLink(expectationDerivation);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case SimpleeventbPackage.NARY_ASSOCIATION_DERIVATION: {
				NAryAssociationDerivation nAryAssociationDerivation = (NAryAssociationDerivation)theEObject;
				T result = caseNAryAssociationDerivation(nAryAssociationDerivation);
				if (result == null) result = caseDerivation(nAryAssociationDerivation);
				if (result == null) result = caseIntraversion(nAryAssociationDerivation);
				if (result == null) result = caseDependency(nAryAssociationDerivation);
				if (result == null) result = caseTraceabilityLink(nAryAssociationDerivation);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case SimpleeventbPackage.NARY_INTERMEDIATE_ENTITY: {
				NAryIntermediateEntity nAryIntermediateEntity = (NAryIntermediateEntity)theEObject;
				T result = caseNAryIntermediateEntity(nAryIntermediateEntity);
				if (result == null) result = caseDerivation(nAryIntermediateEntity);
				if (result == null) result = caseIntraversion(nAryIntermediateEntity);
				if (result == null) result = caseDependency(nAryIntermediateEntity);
				if (result == null) result = caseTraceabilityLink(nAryIntermediateEntity);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case SimpleeventbPackage.NARY_INTERMEDIATE_DIRECTED_ASSOCIATION: {
				NAryIntermediateDirectedAssociation nAryIntermediateDirectedAssociation = (NAryIntermediateDirectedAssociation)theEObject;
				T result = caseNAryIntermediateDirectedAssociation(nAryIntermediateDirectedAssociation);
				if (result == null) result = caseDerivation(nAryIntermediateDirectedAssociation);
				if (result == null) result = caseIntraversion(nAryIntermediateDirectedAssociation);
				if (result == null) result = caseDependency(nAryIntermediateDirectedAssociation);
				if (result == null) result = caseTraceabilityLink(nAryIntermediateDirectedAssociation);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case SimpleeventbPackage.DOMAIN_PROPERTY_DERIVATION: {
				DomainPropertyDerivation domainPropertyDerivation = (DomainPropertyDerivation)theEObject;
				T result = caseDomainPropertyDerivation(domainPropertyDerivation);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			default: return defaultCase(theEObject);
		}
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Event BConcept</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Event BConcept</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseEventBConcept(EventBConcept object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Event BObject</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Event BObject</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseEventBObject(EventBObject object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Project</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Project</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseProject(Project object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Machine</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Machine</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseMachine(Machine object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Context</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Context</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseContext(Context object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Event BExpression</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Event BExpression</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseEventBExpression(EventBExpression object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Event BMachine Expression</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Event BMachine Expression</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseEventBMachineExpression(EventBMachineExpression object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Event BContext Expression</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Event BContext Expression</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseEventBContextExpression(EventBContextExpression object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Variable</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Variable</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseVariable(Variable object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Invariant</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Invariant</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseInvariant(Invariant object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Variant</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Variant</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseVariant(Variant object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Machine Event</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Machine Event</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseMachineEvent(MachineEvent object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Event BEvent Expression</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Event BEvent Expression</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseEventBEventExpression(EventBEventExpression object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Parameter</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Parameter</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseParameter(Parameter object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Guard</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Guard</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseGuard(Guard object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Witness</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Witness</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseWitness(Witness object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Action</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Action</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseAction(Action object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Event BLink</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Event BLink</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseEventBLink(EventBLink object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Machine Refinement</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Machine Refinement</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseMachineRefinement(MachineRefinement object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Context Extension</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Context Extension</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseContextExtension(ContextExtension object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Context View</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Context View</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseContextView(ContextView object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Event Refinement</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Event Refinement</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseEventRefinement(EventRefinement object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Carrier Set</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Carrier Set</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseCarrierSet(CarrierSet object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Constant</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Constant</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseConstant(Constant object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Axiom</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Axiom</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseAxiom(Axiom object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Decomposition Link</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Decomposition Link</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseDecompositionLink(DecompositionLink object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Recomposition Link</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Recomposition Link</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseRecompositionLink(RecompositionLink object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Traceability Link</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Traceability Link</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseTraceabilityLink(TraceabilityLink object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Dependency</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Dependency</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseDependency(Dependency object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Intraversion</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Intraversion</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIntraversion(Intraversion object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Interversion</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Interversion</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseInterversion(Interversion object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Use Link</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Use Link</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseUseLink(UseLink object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Derivation</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Derivation</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseDerivation(Derivation object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Variant Version</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Variant Version</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseVariantVersion(VariantVersion object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Revision</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Revision</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseRevision(Revision object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Agent Derivation</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Agent Derivation</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseAgentDerivation(AgentDerivation object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Entity Object Derivation</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Entity Object Derivation</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseEntityObjectDerivation(EntityObjectDerivation object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Attribute Derivation</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Attribute Derivation</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseAttributeDerivation(AttributeDerivation object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Attribute Domain Derivation</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Attribute Domain Derivation</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseAttributeDomainDerivation(AttributeDomainDerivation object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Directed Association Derivation</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Directed Association Derivation</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseDirectedAssociationDerivation(DirectedAssociationDerivation object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Undirected Association Derivation</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Undirected Association Derivation</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseUndirectedAssociationDerivation(UndirectedAssociationDerivation object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Is ADerivation</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Is ADerivation</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIsADerivation(IsADerivation object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Agent Object Derivation</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Agent Object Derivation</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseAgentObjectDerivation(AgentObjectDerivation object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Event Object Derivation</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Event Object Derivation</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseEventObjectDerivation(EventObjectDerivation object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Requirement Derivation</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Requirement Derivation</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseRequirementDerivation(RequirementDerivation object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Expectation Derivation</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Expectation Derivation</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseExpectationDerivation(ExpectationDerivation object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>NAry Association Derivation</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>NAry Association Derivation</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseNAryAssociationDerivation(NAryAssociationDerivation object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>NAry Intermediate Entity</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>NAry Intermediate Entity</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseNAryIntermediateEntity(NAryIntermediateEntity object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>NAry Intermediate Directed Association</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>NAry Intermediate Directed Association</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseNAryIntermediateDirectedAssociation(NAryIntermediateDirectedAssociation object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Domain Property Derivation</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Domain Property Derivation</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseDomainPropertyDerivation(DomainPropertyDerivation object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>EObject</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch, but this is the last case anyway.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>EObject</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject)
	 * @generated
	 */
	public T defaultCase(EObject object) {
		return null;
	}

} //SimpleeventbSwitch
