/**
 * <copyright>
 * </copyright>
 *
 * $Id: UndirectedAssociationDerivationImpl.java,v 1.1 2010/01/14 12:55:23 cp Exp $
 */
package be.cetic.kaos2eventb.simpleeventb.impl;

import java.util.Collection;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;

import org.eclipse.emf.common.util.EList;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;

import org.eclipse.emf.ecore.impl.ENotificationImpl;

import org.eclipse.emf.ecore.util.EObjectWithInverseResolvingEList;
import org.eclipse.emf.ecore.util.InternalEList;

import be.cetic.kaos2eventb.simpleeventb.Invariant;
import be.cetic.kaos2eventb.simpleeventb.MachineEvent;
import be.cetic.kaos2eventb.simpleeventb.SimpleeventbPackage;
import be.cetic.kaos2eventb.simpleeventb.UndirectedAssociationDerivation;
import be.cetic.kaos2eventb.simpleeventb.Variable;


/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Undirected Association Derivation</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link be.cetic.kaos2eventb.simpleeventb.impl.UndirectedAssociationDerivationImpl#getDerivedVariables <em>Derived Variables</em>}</li>
 *   <li>{@link be.cetic.kaos2eventb.simpleeventb.impl.UndirectedAssociationDerivationImpl#getDerivedInvariant <em>Derived Invariant</em>}</li>
 *   <li>{@link be.cetic.kaos2eventb.simpleeventb.impl.UndirectedAssociationDerivationImpl#getAssociationId <em>Association Id</em>}</li>
 *   <li>{@link be.cetic.kaos2eventb.simpleeventb.impl.UndirectedAssociationDerivationImpl#getAssociationName <em>Association Name</em>}</li>
 *   <li>{@link be.cetic.kaos2eventb.simpleeventb.impl.UndirectedAssociationDerivationImpl#getDerivedEvent <em>Derived Event</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class UndirectedAssociationDerivationImpl extends DerivationImpl implements UndirectedAssociationDerivation {
	/**
	 * The cached value of the '{@link #getDerivedVariables() <em>Derived Variables</em>}' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getDerivedVariables()
	 * @generated
	 * @ordered
	 */
	protected EList<Variable> derivedVariables;

	/**
	 * The cached value of the '{@link #getDerivedInvariant() <em>Derived Invariant</em>}' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getDerivedInvariant()
	 * @generated
	 * @ordered
	 */
	protected EList<Invariant> derivedInvariant;

	/**
	 * The default value of the '{@link #getAssociationId() <em>Association Id</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getAssociationId()
	 * @generated
	 * @ordered
	 */
	protected static final String ASSOCIATION_ID_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getAssociationId() <em>Association Id</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getAssociationId()
	 * @generated
	 * @ordered
	 */
	protected String associationId = ASSOCIATION_ID_EDEFAULT;

	/**
	 * The default value of the '{@link #getAssociationName() <em>Association Name</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getAssociationName()
	 * @generated
	 * @ordered
	 */
	protected static final String ASSOCIATION_NAME_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getAssociationName() <em>Association Name</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getAssociationName()
	 * @generated
	 * @ordered
	 */
	protected String associationName = ASSOCIATION_NAME_EDEFAULT;

	/**
	 * The cached value of the '{@link #getDerivedEvent() <em>Derived Event</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getDerivedEvent()
	 * @generated
	 * @ordered
	 */
	protected MachineEvent derivedEvent;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected UndirectedAssociationDerivationImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return SimpleeventbPackage.Literals.UNDIRECTED_ASSOCIATION_DERIVATION;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<Variable> getDerivedVariables() {
		if (derivedVariables == null) {
			derivedVariables = new EObjectWithInverseResolvingEList<Variable>(Variable.class, this, SimpleeventbPackage.UNDIRECTED_ASSOCIATION_DERIVATION__DERIVED_VARIABLES, SimpleeventbPackage.VARIABLE__DERIVED_FROM_UNDIRECTED_ASSOCIATION);
		}
		return derivedVariables;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<Invariant> getDerivedInvariant() {
		if (derivedInvariant == null) {
			derivedInvariant = new EObjectWithInverseResolvingEList<Invariant>(Invariant.class, this, SimpleeventbPackage.UNDIRECTED_ASSOCIATION_DERIVATION__DERIVED_INVARIANT, SimpleeventbPackage.INVARIANT__DERIVED_FROM_UNDIRECTED_ASSOCIATION);
		}
		return derivedInvariant;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getAssociationId() {
		return associationId;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setAssociationId(String newAssociationId) {
		String oldAssociationId = associationId;
		associationId = newAssociationId;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, SimpleeventbPackage.UNDIRECTED_ASSOCIATION_DERIVATION__ASSOCIATION_ID, oldAssociationId, associationId));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getAssociationName() {
		return associationName;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setAssociationName(String newAssociationName) {
		String oldAssociationName = associationName;
		associationName = newAssociationName;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, SimpleeventbPackage.UNDIRECTED_ASSOCIATION_DERIVATION__ASSOCIATION_NAME, oldAssociationName, associationName));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public MachineEvent getDerivedEvent() {
		if (derivedEvent != null && derivedEvent.eIsProxy()) {
			InternalEObject oldDerivedEvent = (InternalEObject)derivedEvent;
			derivedEvent = (MachineEvent)eResolveProxy(oldDerivedEvent);
			if (derivedEvent != oldDerivedEvent) {
				if (eNotificationRequired())
					eNotify(new ENotificationImpl(this, Notification.RESOLVE, SimpleeventbPackage.UNDIRECTED_ASSOCIATION_DERIVATION__DERIVED_EVENT, oldDerivedEvent, derivedEvent));
			}
		}
		return derivedEvent;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public MachineEvent basicGetDerivedEvent() {
		return derivedEvent;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetDerivedEvent(MachineEvent newDerivedEvent, NotificationChain msgs) {
		MachineEvent oldDerivedEvent = derivedEvent;
		derivedEvent = newDerivedEvent;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, SimpleeventbPackage.UNDIRECTED_ASSOCIATION_DERIVATION__DERIVED_EVENT, oldDerivedEvent, newDerivedEvent);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setDerivedEvent(MachineEvent newDerivedEvent) {
		if (newDerivedEvent != derivedEvent) {
			NotificationChain msgs = null;
			if (derivedEvent != null)
				msgs = ((InternalEObject)derivedEvent).eInverseRemove(this, SimpleeventbPackage.MACHINE_EVENT__DERIVED_FROM_UNDIR_ASSOC, MachineEvent.class, msgs);
			if (newDerivedEvent != null)
				msgs = ((InternalEObject)newDerivedEvent).eInverseAdd(this, SimpleeventbPackage.MACHINE_EVENT__DERIVED_FROM_UNDIR_ASSOC, MachineEvent.class, msgs);
			msgs = basicSetDerivedEvent(newDerivedEvent, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, SimpleeventbPackage.UNDIRECTED_ASSOCIATION_DERIVATION__DERIVED_EVENT, newDerivedEvent, newDerivedEvent));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case SimpleeventbPackage.UNDIRECTED_ASSOCIATION_DERIVATION__DERIVED_VARIABLES:
				return ((InternalEList<InternalEObject>)(InternalEList<?>)getDerivedVariables()).basicAdd(otherEnd, msgs);
			case SimpleeventbPackage.UNDIRECTED_ASSOCIATION_DERIVATION__DERIVED_INVARIANT:
				return ((InternalEList<InternalEObject>)(InternalEList<?>)getDerivedInvariant()).basicAdd(otherEnd, msgs);
			case SimpleeventbPackage.UNDIRECTED_ASSOCIATION_DERIVATION__DERIVED_EVENT:
				if (derivedEvent != null)
					msgs = ((InternalEObject)derivedEvent).eInverseRemove(this, SimpleeventbPackage.MACHINE_EVENT__DERIVED_FROM_UNDIR_ASSOC, MachineEvent.class, msgs);
				return basicSetDerivedEvent((MachineEvent)otherEnd, msgs);
		}
		return super.eInverseAdd(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case SimpleeventbPackage.UNDIRECTED_ASSOCIATION_DERIVATION__DERIVED_VARIABLES:
				return ((InternalEList<?>)getDerivedVariables()).basicRemove(otherEnd, msgs);
			case SimpleeventbPackage.UNDIRECTED_ASSOCIATION_DERIVATION__DERIVED_INVARIANT:
				return ((InternalEList<?>)getDerivedInvariant()).basicRemove(otherEnd, msgs);
			case SimpleeventbPackage.UNDIRECTED_ASSOCIATION_DERIVATION__DERIVED_EVENT:
				return basicSetDerivedEvent(null, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case SimpleeventbPackage.UNDIRECTED_ASSOCIATION_DERIVATION__DERIVED_VARIABLES:
				return getDerivedVariables();
			case SimpleeventbPackage.UNDIRECTED_ASSOCIATION_DERIVATION__DERIVED_INVARIANT:
				return getDerivedInvariant();
			case SimpleeventbPackage.UNDIRECTED_ASSOCIATION_DERIVATION__ASSOCIATION_ID:
				return getAssociationId();
			case SimpleeventbPackage.UNDIRECTED_ASSOCIATION_DERIVATION__ASSOCIATION_NAME:
				return getAssociationName();
			case SimpleeventbPackage.UNDIRECTED_ASSOCIATION_DERIVATION__DERIVED_EVENT:
				if (resolve) return getDerivedEvent();
				return basicGetDerivedEvent();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case SimpleeventbPackage.UNDIRECTED_ASSOCIATION_DERIVATION__DERIVED_VARIABLES:
				getDerivedVariables().clear();
				getDerivedVariables().addAll((Collection<? extends Variable>)newValue);
				return;
			case SimpleeventbPackage.UNDIRECTED_ASSOCIATION_DERIVATION__DERIVED_INVARIANT:
				getDerivedInvariant().clear();
				getDerivedInvariant().addAll((Collection<? extends Invariant>)newValue);
				return;
			case SimpleeventbPackage.UNDIRECTED_ASSOCIATION_DERIVATION__ASSOCIATION_ID:
				setAssociationId((String)newValue);
				return;
			case SimpleeventbPackage.UNDIRECTED_ASSOCIATION_DERIVATION__ASSOCIATION_NAME:
				setAssociationName((String)newValue);
				return;
			case SimpleeventbPackage.UNDIRECTED_ASSOCIATION_DERIVATION__DERIVED_EVENT:
				setDerivedEvent((MachineEvent)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case SimpleeventbPackage.UNDIRECTED_ASSOCIATION_DERIVATION__DERIVED_VARIABLES:
				getDerivedVariables().clear();
				return;
			case SimpleeventbPackage.UNDIRECTED_ASSOCIATION_DERIVATION__DERIVED_INVARIANT:
				getDerivedInvariant().clear();
				return;
			case SimpleeventbPackage.UNDIRECTED_ASSOCIATION_DERIVATION__ASSOCIATION_ID:
				setAssociationId(ASSOCIATION_ID_EDEFAULT);
				return;
			case SimpleeventbPackage.UNDIRECTED_ASSOCIATION_DERIVATION__ASSOCIATION_NAME:
				setAssociationName(ASSOCIATION_NAME_EDEFAULT);
				return;
			case SimpleeventbPackage.UNDIRECTED_ASSOCIATION_DERIVATION__DERIVED_EVENT:
				setDerivedEvent((MachineEvent)null);
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case SimpleeventbPackage.UNDIRECTED_ASSOCIATION_DERIVATION__DERIVED_VARIABLES:
				return derivedVariables != null && !derivedVariables.isEmpty();
			case SimpleeventbPackage.UNDIRECTED_ASSOCIATION_DERIVATION__DERIVED_INVARIANT:
				return derivedInvariant != null && !derivedInvariant.isEmpty();
			case SimpleeventbPackage.UNDIRECTED_ASSOCIATION_DERIVATION__ASSOCIATION_ID:
				return ASSOCIATION_ID_EDEFAULT == null ? associationId != null : !ASSOCIATION_ID_EDEFAULT.equals(associationId);
			case SimpleeventbPackage.UNDIRECTED_ASSOCIATION_DERIVATION__ASSOCIATION_NAME:
				return ASSOCIATION_NAME_EDEFAULT == null ? associationName != null : !ASSOCIATION_NAME_EDEFAULT.equals(associationName);
			case SimpleeventbPackage.UNDIRECTED_ASSOCIATION_DERIVATION__DERIVED_EVENT:
				return derivedEvent != null;
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuffer result = new StringBuffer(super.toString());
		result.append(" (associationId: ");
		result.append(associationId);
		result.append(", associationName: ");
		result.append(associationName);
		result.append(')');
		return result.toString();
	}

} //UndirectedAssociationDerivationImpl
