/**
 * <copyright>
 * </copyright>
 *
 * $Id: MachineImpl.java,v 1.1 2010/01/14 12:55:21 cp Exp $
 */
package be.cetic.kaos2eventb.simpleeventb.impl;

import java.util.Collection;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;

import org.eclipse.emf.common.util.EList;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;

import org.eclipse.emf.ecore.impl.ENotificationImpl;

import org.eclipse.emf.ecore.util.EObjectContainmentWithInverseEList;
import org.eclipse.emf.ecore.util.EObjectWithInverseResolvingEList;
import org.eclipse.emf.ecore.util.InternalEList;

import be.cetic.kaos2eventb.simpleeventb.AgentDerivation;
import be.cetic.kaos2eventb.simpleeventb.ContextView;
import be.cetic.kaos2eventb.simpleeventb.DecompositionLink;
import be.cetic.kaos2eventb.simpleeventb.Invariant;
import be.cetic.kaos2eventb.simpleeventb.Machine;
import be.cetic.kaos2eventb.simpleeventb.MachineEvent;
import be.cetic.kaos2eventb.simpleeventb.MachineRefinement;
import be.cetic.kaos2eventb.simpleeventb.RecompositionLink;
import be.cetic.kaos2eventb.simpleeventb.SimpleeventbPackage;
import be.cetic.kaos2eventb.simpleeventb.Variable;
import be.cetic.kaos2eventb.simpleeventb.Variant;


/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Machine</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link be.cetic.kaos2eventb.simpleeventb.impl.MachineImpl#getVariables <em>Variables</em>}</li>
 *   <li>{@link be.cetic.kaos2eventb.simpleeventb.impl.MachineImpl#getInvariants <em>Invariants</em>}</li>
 *   <li>{@link be.cetic.kaos2eventb.simpleeventb.impl.MachineImpl#getVariants <em>Variants</em>}</li>
 *   <li>{@link be.cetic.kaos2eventb.simpleeventb.impl.MachineImpl#getEvents <em>Events</em>}</li>
 *   <li>{@link be.cetic.kaos2eventb.simpleeventb.impl.MachineImpl#getViews <em>Views</em>}</li>
 *   <li>{@link be.cetic.kaos2eventb.simpleeventb.impl.MachineImpl#getRefinedBy <em>Refined By</em>}</li>
 *   <li>{@link be.cetic.kaos2eventb.simpleeventb.impl.MachineImpl#getRefines <em>Refines</em>}</li>
 *   <li>{@link be.cetic.kaos2eventb.simpleeventb.impl.MachineImpl#getDecomposedIn <em>Decomposed In</em>}</li>
 *   <li>{@link be.cetic.kaos2eventb.simpleeventb.impl.MachineImpl#getDecomposing <em>Decomposing</em>}</li>
 *   <li>{@link be.cetic.kaos2eventb.simpleeventb.impl.MachineImpl#getRecomposedIn <em>Recomposed In</em>}</li>
 *   <li>{@link be.cetic.kaos2eventb.simpleeventb.impl.MachineImpl#getRecomposing <em>Recomposing</em>}</li>
 *   <li>{@link be.cetic.kaos2eventb.simpleeventb.impl.MachineImpl#getDerivedFromAgent <em>Derived From Agent</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class MachineImpl extends EventBObjectImpl implements Machine {
	/**
	 * The cached value of the '{@link #getVariables() <em>Variables</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getVariables()
	 * @generated
	 * @ordered
	 */
	protected EList<Variable> variables;

	/**
	 * The cached value of the '{@link #getInvariants() <em>Invariants</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getInvariants()
	 * @generated
	 * @ordered
	 */
	protected EList<Invariant> invariants;

	/**
	 * The cached value of the '{@link #getVariants() <em>Variants</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getVariants()
	 * @generated
	 * @ordered
	 */
	protected EList<Variant> variants;

	/**
	 * The cached value of the '{@link #getEvents() <em>Events</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getEvents()
	 * @generated
	 * @ordered
	 */
	protected EList<MachineEvent> events;

	/**
	 * The cached value of the '{@link #getViews() <em>Views</em>}' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getViews()
	 * @generated
	 * @ordered
	 */
	protected EList<ContextView> views;

	/**
	 * The cached value of the '{@link #getRefinedBy() <em>Refined By</em>}' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getRefinedBy()
	 * @generated
	 * @ordered
	 */
	protected EList<MachineRefinement> refinedBy;

	/**
	 * The cached value of the '{@link #getRefines() <em>Refines</em>}' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getRefines()
	 * @generated
	 * @ordered
	 */
	protected EList<MachineRefinement> refines;

	/**
	 * The cached value of the '{@link #getDecomposedIn() <em>Decomposed In</em>}' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getDecomposedIn()
	 * @generated
	 * @ordered
	 */
	protected EList<DecompositionLink> decomposedIn;

	/**
	 * The cached value of the '{@link #getDecomposing() <em>Decomposing</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getDecomposing()
	 * @generated
	 * @ordered
	 */
	protected DecompositionLink decomposing;

	/**
	 * The cached value of the '{@link #getRecomposedIn() <em>Recomposed In</em>}' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getRecomposedIn()
	 * @generated
	 * @ordered
	 */
	protected EList<RecompositionLink> recomposedIn;

	/**
	 * The cached value of the '{@link #getRecomposing() <em>Recomposing</em>}' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getRecomposing()
	 * @generated
	 * @ordered
	 */
	protected EList<RecompositionLink> recomposing;

	/**
	 * The cached value of the '{@link #getDerivedFromAgent() <em>Derived From Agent</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getDerivedFromAgent()
	 * @generated
	 * @ordered
	 */
	protected AgentDerivation derivedFromAgent;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected MachineImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return SimpleeventbPackage.Literals.MACHINE;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<Variable> getVariables() {
		if (variables == null) {
			variables = new EObjectContainmentWithInverseEList<Variable>(Variable.class, this, SimpleeventbPackage.MACHINE__VARIABLES, SimpleeventbPackage.VARIABLE__MACHINE);
		}
		return variables;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<Invariant> getInvariants() {
		if (invariants == null) {
			invariants = new EObjectContainmentWithInverseEList<Invariant>(Invariant.class, this, SimpleeventbPackage.MACHINE__INVARIANTS, SimpleeventbPackage.INVARIANT__MACHINE);
		}
		return invariants;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<Variant> getVariants() {
		if (variants == null) {
			variants = new EObjectContainmentWithInverseEList<Variant>(Variant.class, this, SimpleeventbPackage.MACHINE__VARIANTS, SimpleeventbPackage.VARIANT__MACHINE);
		}
		return variants;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<MachineEvent> getEvents() {
		if (events == null) {
			events = new EObjectContainmentWithInverseEList<MachineEvent>(MachineEvent.class, this, SimpleeventbPackage.MACHINE__EVENTS, SimpleeventbPackage.MACHINE_EVENT__MACHINE);
		}
		return events;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<ContextView> getViews() {
		if (views == null) {
			views = new EObjectWithInverseResolvingEList<ContextView>(ContextView.class, this, SimpleeventbPackage.MACHINE__VIEWS, SimpleeventbPackage.CONTEXT_VIEW__SEEING_MACHINE);
		}
		return views;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<MachineRefinement> getRefinedBy() {
		if (refinedBy == null) {
			refinedBy = new EObjectWithInverseResolvingEList<MachineRefinement>(MachineRefinement.class, this, SimpleeventbPackage.MACHINE__REFINED_BY, SimpleeventbPackage.MACHINE_REFINEMENT__REFINED_MACHINE);
		}
		return refinedBy;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<MachineRefinement> getRefines() {
		if (refines == null) {
			refines = new EObjectWithInverseResolvingEList<MachineRefinement>(MachineRefinement.class, this, SimpleeventbPackage.MACHINE__REFINES, SimpleeventbPackage.MACHINE_REFINEMENT__REFINING_MACHINE);
		}
		return refines;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<DecompositionLink> getDecomposedIn() {
		if (decomposedIn == null) {
			decomposedIn = new EObjectWithInverseResolvingEList<DecompositionLink>(DecompositionLink.class, this, SimpleeventbPackage.MACHINE__DECOMPOSED_IN, SimpleeventbPackage.DECOMPOSITION_LINK__DECOMPOSED_MACHINE);
		}
		return decomposedIn;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public DecompositionLink getDecomposing() {
		if (decomposing != null && decomposing.eIsProxy()) {
			InternalEObject oldDecomposing = (InternalEObject)decomposing;
			decomposing = (DecompositionLink)eResolveProxy(oldDecomposing);
			if (decomposing != oldDecomposing) {
				if (eNotificationRequired())
					eNotify(new ENotificationImpl(this, Notification.RESOLVE, SimpleeventbPackage.MACHINE__DECOMPOSING, oldDecomposing, decomposing));
			}
		}
		return decomposing;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public DecompositionLink basicGetDecomposing() {
		return decomposing;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetDecomposing(DecompositionLink newDecomposing, NotificationChain msgs) {
		DecompositionLink oldDecomposing = decomposing;
		decomposing = newDecomposing;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, SimpleeventbPackage.MACHINE__DECOMPOSING, oldDecomposing, newDecomposing);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setDecomposing(DecompositionLink newDecomposing) {
		if (newDecomposing != decomposing) {
			NotificationChain msgs = null;
			if (decomposing != null)
				msgs = ((InternalEObject)decomposing).eInverseRemove(this, SimpleeventbPackage.DECOMPOSITION_LINK__DECOMPOSING_MACHINES, DecompositionLink.class, msgs);
			if (newDecomposing != null)
				msgs = ((InternalEObject)newDecomposing).eInverseAdd(this, SimpleeventbPackage.DECOMPOSITION_LINK__DECOMPOSING_MACHINES, DecompositionLink.class, msgs);
			msgs = basicSetDecomposing(newDecomposing, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, SimpleeventbPackage.MACHINE__DECOMPOSING, newDecomposing, newDecomposing));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<RecompositionLink> getRecomposedIn() {
		if (recomposedIn == null) {
			recomposedIn = new EObjectWithInverseResolvingEList.ManyInverse<RecompositionLink>(RecompositionLink.class, this, SimpleeventbPackage.MACHINE__RECOMPOSED_IN, SimpleeventbPackage.RECOMPOSITION_LINK__RECOMPOSING_MACHINES);
		}
		return recomposedIn;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<RecompositionLink> getRecomposing() {
		if (recomposing == null) {
			recomposing = new EObjectWithInverseResolvingEList<RecompositionLink>(RecompositionLink.class, this, SimpleeventbPackage.MACHINE__RECOMPOSING, SimpleeventbPackage.RECOMPOSITION_LINK__RECOMPOSED_MACHINE);
		}
		return recomposing;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public AgentDerivation getDerivedFromAgent() {
		if (derivedFromAgent != null && derivedFromAgent.eIsProxy()) {
			InternalEObject oldDerivedFromAgent = (InternalEObject)derivedFromAgent;
			derivedFromAgent = (AgentDerivation)eResolveProxy(oldDerivedFromAgent);
			if (derivedFromAgent != oldDerivedFromAgent) {
				if (eNotificationRequired())
					eNotify(new ENotificationImpl(this, Notification.RESOLVE, SimpleeventbPackage.MACHINE__DERIVED_FROM_AGENT, oldDerivedFromAgent, derivedFromAgent));
			}
		}
		return derivedFromAgent;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public AgentDerivation basicGetDerivedFromAgent() {
		return derivedFromAgent;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetDerivedFromAgent(AgentDerivation newDerivedFromAgent, NotificationChain msgs) {
		AgentDerivation oldDerivedFromAgent = derivedFromAgent;
		derivedFromAgent = newDerivedFromAgent;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, SimpleeventbPackage.MACHINE__DERIVED_FROM_AGENT, oldDerivedFromAgent, newDerivedFromAgent);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setDerivedFromAgent(AgentDerivation newDerivedFromAgent) {
		if (newDerivedFromAgent != derivedFromAgent) {
			NotificationChain msgs = null;
			if (derivedFromAgent != null)
				msgs = ((InternalEObject)derivedFromAgent).eInverseRemove(this, SimpleeventbPackage.AGENT_DERIVATION__DERIVED_MACHINE, AgentDerivation.class, msgs);
			if (newDerivedFromAgent != null)
				msgs = ((InternalEObject)newDerivedFromAgent).eInverseAdd(this, SimpleeventbPackage.AGENT_DERIVATION__DERIVED_MACHINE, AgentDerivation.class, msgs);
			msgs = basicSetDerivedFromAgent(newDerivedFromAgent, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, SimpleeventbPackage.MACHINE__DERIVED_FROM_AGENT, newDerivedFromAgent, newDerivedFromAgent));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case SimpleeventbPackage.MACHINE__VARIABLES:
				return ((InternalEList<InternalEObject>)(InternalEList<?>)getVariables()).basicAdd(otherEnd, msgs);
			case SimpleeventbPackage.MACHINE__INVARIANTS:
				return ((InternalEList<InternalEObject>)(InternalEList<?>)getInvariants()).basicAdd(otherEnd, msgs);
			case SimpleeventbPackage.MACHINE__VARIANTS:
				return ((InternalEList<InternalEObject>)(InternalEList<?>)getVariants()).basicAdd(otherEnd, msgs);
			case SimpleeventbPackage.MACHINE__EVENTS:
				return ((InternalEList<InternalEObject>)(InternalEList<?>)getEvents()).basicAdd(otherEnd, msgs);
			case SimpleeventbPackage.MACHINE__VIEWS:
				return ((InternalEList<InternalEObject>)(InternalEList<?>)getViews()).basicAdd(otherEnd, msgs);
			case SimpleeventbPackage.MACHINE__REFINED_BY:
				return ((InternalEList<InternalEObject>)(InternalEList<?>)getRefinedBy()).basicAdd(otherEnd, msgs);
			case SimpleeventbPackage.MACHINE__REFINES:
				return ((InternalEList<InternalEObject>)(InternalEList<?>)getRefines()).basicAdd(otherEnd, msgs);
			case SimpleeventbPackage.MACHINE__DECOMPOSED_IN:
				return ((InternalEList<InternalEObject>)(InternalEList<?>)getDecomposedIn()).basicAdd(otherEnd, msgs);
			case SimpleeventbPackage.MACHINE__DECOMPOSING:
				if (decomposing != null)
					msgs = ((InternalEObject)decomposing).eInverseRemove(this, SimpleeventbPackage.DECOMPOSITION_LINK__DECOMPOSING_MACHINES, DecompositionLink.class, msgs);
				return basicSetDecomposing((DecompositionLink)otherEnd, msgs);
			case SimpleeventbPackage.MACHINE__RECOMPOSED_IN:
				return ((InternalEList<InternalEObject>)(InternalEList<?>)getRecomposedIn()).basicAdd(otherEnd, msgs);
			case SimpleeventbPackage.MACHINE__RECOMPOSING:
				return ((InternalEList<InternalEObject>)(InternalEList<?>)getRecomposing()).basicAdd(otherEnd, msgs);
			case SimpleeventbPackage.MACHINE__DERIVED_FROM_AGENT:
				if (derivedFromAgent != null)
					msgs = ((InternalEObject)derivedFromAgent).eInverseRemove(this, SimpleeventbPackage.AGENT_DERIVATION__DERIVED_MACHINE, AgentDerivation.class, msgs);
				return basicSetDerivedFromAgent((AgentDerivation)otherEnd, msgs);
		}
		return super.eInverseAdd(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case SimpleeventbPackage.MACHINE__VARIABLES:
				return ((InternalEList<?>)getVariables()).basicRemove(otherEnd, msgs);
			case SimpleeventbPackage.MACHINE__INVARIANTS:
				return ((InternalEList<?>)getInvariants()).basicRemove(otherEnd, msgs);
			case SimpleeventbPackage.MACHINE__VARIANTS:
				return ((InternalEList<?>)getVariants()).basicRemove(otherEnd, msgs);
			case SimpleeventbPackage.MACHINE__EVENTS:
				return ((InternalEList<?>)getEvents()).basicRemove(otherEnd, msgs);
			case SimpleeventbPackage.MACHINE__VIEWS:
				return ((InternalEList<?>)getViews()).basicRemove(otherEnd, msgs);
			case SimpleeventbPackage.MACHINE__REFINED_BY:
				return ((InternalEList<?>)getRefinedBy()).basicRemove(otherEnd, msgs);
			case SimpleeventbPackage.MACHINE__REFINES:
				return ((InternalEList<?>)getRefines()).basicRemove(otherEnd, msgs);
			case SimpleeventbPackage.MACHINE__DECOMPOSED_IN:
				return ((InternalEList<?>)getDecomposedIn()).basicRemove(otherEnd, msgs);
			case SimpleeventbPackage.MACHINE__DECOMPOSING:
				return basicSetDecomposing(null, msgs);
			case SimpleeventbPackage.MACHINE__RECOMPOSED_IN:
				return ((InternalEList<?>)getRecomposedIn()).basicRemove(otherEnd, msgs);
			case SimpleeventbPackage.MACHINE__RECOMPOSING:
				return ((InternalEList<?>)getRecomposing()).basicRemove(otherEnd, msgs);
			case SimpleeventbPackage.MACHINE__DERIVED_FROM_AGENT:
				return basicSetDerivedFromAgent(null, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case SimpleeventbPackage.MACHINE__VARIABLES:
				return getVariables();
			case SimpleeventbPackage.MACHINE__INVARIANTS:
				return getInvariants();
			case SimpleeventbPackage.MACHINE__VARIANTS:
				return getVariants();
			case SimpleeventbPackage.MACHINE__EVENTS:
				return getEvents();
			case SimpleeventbPackage.MACHINE__VIEWS:
				return getViews();
			case SimpleeventbPackage.MACHINE__REFINED_BY:
				return getRefinedBy();
			case SimpleeventbPackage.MACHINE__REFINES:
				return getRefines();
			case SimpleeventbPackage.MACHINE__DECOMPOSED_IN:
				return getDecomposedIn();
			case SimpleeventbPackage.MACHINE__DECOMPOSING:
				if (resolve) return getDecomposing();
				return basicGetDecomposing();
			case SimpleeventbPackage.MACHINE__RECOMPOSED_IN:
				return getRecomposedIn();
			case SimpleeventbPackage.MACHINE__RECOMPOSING:
				return getRecomposing();
			case SimpleeventbPackage.MACHINE__DERIVED_FROM_AGENT:
				if (resolve) return getDerivedFromAgent();
				return basicGetDerivedFromAgent();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case SimpleeventbPackage.MACHINE__VARIABLES:
				getVariables().clear();
				getVariables().addAll((Collection<? extends Variable>)newValue);
				return;
			case SimpleeventbPackage.MACHINE__INVARIANTS:
				getInvariants().clear();
				getInvariants().addAll((Collection<? extends Invariant>)newValue);
				return;
			case SimpleeventbPackage.MACHINE__VARIANTS:
				getVariants().clear();
				getVariants().addAll((Collection<? extends Variant>)newValue);
				return;
			case SimpleeventbPackage.MACHINE__EVENTS:
				getEvents().clear();
				getEvents().addAll((Collection<? extends MachineEvent>)newValue);
				return;
			case SimpleeventbPackage.MACHINE__VIEWS:
				getViews().clear();
				getViews().addAll((Collection<? extends ContextView>)newValue);
				return;
			case SimpleeventbPackage.MACHINE__REFINED_BY:
				getRefinedBy().clear();
				getRefinedBy().addAll((Collection<? extends MachineRefinement>)newValue);
				return;
			case SimpleeventbPackage.MACHINE__REFINES:
				getRefines().clear();
				getRefines().addAll((Collection<? extends MachineRefinement>)newValue);
				return;
			case SimpleeventbPackage.MACHINE__DECOMPOSED_IN:
				getDecomposedIn().clear();
				getDecomposedIn().addAll((Collection<? extends DecompositionLink>)newValue);
				return;
			case SimpleeventbPackage.MACHINE__DECOMPOSING:
				setDecomposing((DecompositionLink)newValue);
				return;
			case SimpleeventbPackage.MACHINE__RECOMPOSED_IN:
				getRecomposedIn().clear();
				getRecomposedIn().addAll((Collection<? extends RecompositionLink>)newValue);
				return;
			case SimpleeventbPackage.MACHINE__RECOMPOSING:
				getRecomposing().clear();
				getRecomposing().addAll((Collection<? extends RecompositionLink>)newValue);
				return;
			case SimpleeventbPackage.MACHINE__DERIVED_FROM_AGENT:
				setDerivedFromAgent((AgentDerivation)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case SimpleeventbPackage.MACHINE__VARIABLES:
				getVariables().clear();
				return;
			case SimpleeventbPackage.MACHINE__INVARIANTS:
				getInvariants().clear();
				return;
			case SimpleeventbPackage.MACHINE__VARIANTS:
				getVariants().clear();
				return;
			case SimpleeventbPackage.MACHINE__EVENTS:
				getEvents().clear();
				return;
			case SimpleeventbPackage.MACHINE__VIEWS:
				getViews().clear();
				return;
			case SimpleeventbPackage.MACHINE__REFINED_BY:
				getRefinedBy().clear();
				return;
			case SimpleeventbPackage.MACHINE__REFINES:
				getRefines().clear();
				return;
			case SimpleeventbPackage.MACHINE__DECOMPOSED_IN:
				getDecomposedIn().clear();
				return;
			case SimpleeventbPackage.MACHINE__DECOMPOSING:
				setDecomposing((DecompositionLink)null);
				return;
			case SimpleeventbPackage.MACHINE__RECOMPOSED_IN:
				getRecomposedIn().clear();
				return;
			case SimpleeventbPackage.MACHINE__RECOMPOSING:
				getRecomposing().clear();
				return;
			case SimpleeventbPackage.MACHINE__DERIVED_FROM_AGENT:
				setDerivedFromAgent((AgentDerivation)null);
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case SimpleeventbPackage.MACHINE__VARIABLES:
				return variables != null && !variables.isEmpty();
			case SimpleeventbPackage.MACHINE__INVARIANTS:
				return invariants != null && !invariants.isEmpty();
			case SimpleeventbPackage.MACHINE__VARIANTS:
				return variants != null && !variants.isEmpty();
			case SimpleeventbPackage.MACHINE__EVENTS:
				return events != null && !events.isEmpty();
			case SimpleeventbPackage.MACHINE__VIEWS:
				return views != null && !views.isEmpty();
			case SimpleeventbPackage.MACHINE__REFINED_BY:
				return refinedBy != null && !refinedBy.isEmpty();
			case SimpleeventbPackage.MACHINE__REFINES:
				return refines != null && !refines.isEmpty();
			case SimpleeventbPackage.MACHINE__DECOMPOSED_IN:
				return decomposedIn != null && !decomposedIn.isEmpty();
			case SimpleeventbPackage.MACHINE__DECOMPOSING:
				return decomposing != null;
			case SimpleeventbPackage.MACHINE__RECOMPOSED_IN:
				return recomposedIn != null && !recomposedIn.isEmpty();
			case SimpleeventbPackage.MACHINE__RECOMPOSING:
				return recomposing != null && !recomposing.isEmpty();
			case SimpleeventbPackage.MACHINE__DERIVED_FROM_AGENT:
				return derivedFromAgent != null;
		}
		return super.eIsSet(featureID);
	}

} //MachineImpl
