package be.cetic.kaos2eventb.main;

import java.io.File;
import java.io.FileInputStream;
import java.util.Collections;

import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.util.URI;

import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;
import org.eclipse.m2m.atl.core.IExtractor;
import org.eclipse.m2m.atl.core.IInjector;
import org.eclipse.m2m.atl.core.IModel;
import org.eclipse.m2m.atl.core.IReferenceModel;
import org.eclipse.m2m.atl.core.ModelFactory;
import org.eclipse.m2m.atl.core.emf.EMFExtractor;
import org.eclipse.m2m.atl.core.emf.EMFInjector;
import org.eclipse.m2m.atl.core.emf.EMFModelFactory;
import org.eclipse.m2m.atl.core.launch.ILauncher;
import org.eclipse.m2m.atl.core.service.CoreService;
import org.eclipse.m2m.atl.engine.emfvm.launch.EMFVMLauncher;

import be.cetic.kaos2eventb.simpleeventb.Project;
import be.cetic.kaos2eventb.simpleeventb.impl.SimpleeventbPackageImpl;
import be.cetic.kaos2eventb.util.ObjectiverModelToXMI;
import be.cetic.kaos2eventb.util.PrettyPrintProject;

public class Main {

	private static String simpleeventbMMURI = "platform:/resource/be.cetic.kaos2eventb/metamodel/eventb/simpleeventb.ecore";
	private static String simpleeventbMMEffectiveURI = "file:./metamodel/eventb/simpleeventb.ecore";

	/**
	 * This main connect to Objectiver (Launch Objectiver ans start RMI server
	 * before launching this main), get the model, launch the ATL
	 * transformation, load the created simpleeventb model in memory and print
	 * the created model.
	 * 
	 * @param args
	 */
	public static void main(String[] args) {

		System.out.println("----- Test ATL");

		try {
			// Get XMI file:

			ObjectiverModelToXMI objectiverModel = new ObjectiverModelToXMI();
			objectiverModel.ping();
			System.out.println("Connected to Objectiver");

			File kaosOut = new File("." + File.separator + "model"
					+ File.separator + "test.xmi");
			if (kaosOut.exists()) {
				kaosOut.delete();
			}
			kaosOut.createNewFile();
			objectiverModel.toXMIFile(
					"file:../be.cetic.objectiver.model/src/open/kaos.ecore",
					kaosOut);

			// /////////////////////////////////////

			System.out.println("----- Launch ATL transformation");

			// Defaults

			CoreService.registerLauncher(new EMFVMLauncher());
			CoreService.registerFactory("EMF", EMFModelFactory.class);
			CoreService.registerExtractor("EMF", new EMFExtractor());
			CoreService.registerInjector("EMF", new EMFInjector());

			ModelFactory factory = CoreService.createModelFactory("EMF"); //$NON-NLS-1$
			IInjector injector = CoreService.getInjector("EMF");
			IExtractor extractor = CoreService.getExtractor("EMF");

			// Metamodels
			IReferenceModel kaosMM = factory.newReferenceModel();
			injector.inject(kaosMM,
					"file:../be.cetic.objectiver.model/src/open/kaos.ecore");

			IReferenceModel simpleeventbMM = factory.newReferenceModel();
			injector.inject(simpleeventbMM, simpleeventbMMEffectiveURI);

			// Getting launcher
			ILauncher launcher = null;
			launcher = CoreService.getLauncher("EMF-specific VM"); //$NON-NLS-1$
			launcher.initialize(Collections.<String, Object> emptyMap());

			// Creating models
			IModel simpleeventbModel = factory.newModel(simpleeventbMM);
			IModel kaosModel = factory.newModel(kaosMM);

			// Loading existing model
			File in = new File("." + File.separator + "model" + File.separator
					+ "test.xmi");
			File out = new File("." + File.separator + "model" + File.separator
					+ "out.simpleeventb");
			if (out.exists()) {
				out.delete();
			}
			out.createNewFile();

			injector.inject(kaosModel, in.toURI().toURL().toString());

			// Launching
			launcher.addOutModel(simpleeventbModel, "OUT", "SIMPLEEVENTB");
			launcher.addInOutModel(kaosModel, "IN", "KAOS");

			File asmFile = new File("." + File.separator + "transformation"
					+ File.separator + "KAOS2EventB.asm");

			launcher.launch(ILauncher.RUN_MODE, new NullProgressMonitor(),
					Collections.<String, Object> emptyMap(),
					new FileInputStream(asmFile));

			// Saving model
			extractor
					.extract(simpleeventbModel, out.toURI().toURL().toString());
		} catch (Exception e) {
			e.printStackTrace();
		}
		// /////////////////////////////////////////////

		System.out.println("----- Lecture out.XMI");

		ResourceSet resourceSet = new ResourceSetImpl();
		URI fileUri = URI.createFileURI("." + File.separator + "model"
				+ File.separator + "out.xmi");
		Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().put("*",
				new XMIResourceFactoryImpl());

		URI mmURI = URI.createURI(simpleeventbMMURI);
		URI effectiveMMURI = URI.createURI(simpleeventbMMEffectiveURI);

		resourceSet.getURIConverter().getURIMap().put(mmURI, effectiveMMURI);
		resourceSet.getPackageRegistry().put(
				"file:./metamodel/eventb/simpleeventb.ecore",
				SimpleeventbPackageImpl.eINSTANCE);
		Resource simpleeventbResource = resourceSet.getResource(fileUri, true);

		Project prj = (Project) simpleeventbResource.getContents().get(0);

		System.out.println("File deserialized");

		// ////////////////////////////////////////

		System.out.println("----- Project pretty print :");

		System.out.println(PrettyPrintProject.print(prj));

		System.out.println("----- End ");

	}

}
